#***************************************************************
#SimLab Version 2024.1 
#Created at Mon Nov 25 11:16:07 2024
#Author: Alessio Librandi
#***************************************************************
from hwx import simlab




UnitSystem=''' <UnitSystem UUID="3aca8564-4d38-4b0b-887c-6a542d4001c6">
  <SetCurrentDisplaySystem Name="MMKS (mm kg N C s)"/>
 </UnitSystem>''';
simlab.execute(UnitSystem);

###Variable defined Through GUI #####################
#RBEBodyNames=simlab.getSelectedBodies();

######################################
####Debug Mode
if 0==1:
    EquivFlag='true';
    Tolerance="1";
    ConnectorType="Spring";
    
    CS="Global";
    DxStiff="8e08";
    DyStiff="9e08";
    DzStiff="2e08";
    RxStiff="4";
    RyStiff="7";
    RzStiff="2";
    ParameterFlag='false';





#######################################################
#Note: in the spring definition, Flag1 defines DOES as sum of X=1, Y=2, Z=4, RX=8, RY=16, RZ=32       
SpringFlag=(eval(DxStiff)>0)*1+(eval(DyStiff)>0)*2+(eval(DzStiff)>0)*4+(eval(RxStiff)>0)*8+(eval(RyStiff)>0)*16+(eval(RzStiff)>0)*32;
if ParameterFlag=='true':
    SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
      <ParamInfo Type="stiffness" Value="'''+DxStiff+'''" Name="DxStiff"/>
     </Parameters>''';
    simlab.execute(SimLabParameters);
    SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
      <ParamInfo Type="stiffness" Value="'''+DyStiff+'''" Name="DyStiff"/>
     </Parameters>''';
    simlab.execute(SimLabParameters);
    SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
      <ParamInfo Type="stiffness" Value="'''+DzStiff+'''" Name="DzStiff"/>
     </Parameters>''';
    simlab.execute(SimLabParameters);
    SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
      <ParamInfo Type="stiffness" Value="'''+RxStiff+'''" Name="RxStiff"/>
     </Parameters>''';
    simlab.execute(SimLabParameters);
    SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
      <ParamInfo Type="stiffness" Value="'''+RyStiff+'''" Name="RyStiff"/>
     </Parameters>''';
    simlab.execute(SimLabParameters);
    SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
      <ParamInfo Type="stiffness" Value="'''+RzStiff+'''" Name="RzStiff"/>
     </Parameters>''';
    simlab.execute(SimLabParameters);
    DxStiff="$DxStiff";
    DyStiff="$DyStiff";
    DzStiff="$DzStiff";
    RxStiff="$RxStiff";
    RyStiff="$RyStiff";
    RzStiff="$RzStiff";



def main():
  
    RBEArray=simlab.getSelectedBodies();
    RBEModel=simlab.getParentModelFromSelectedEntities("Body"); 
    ##Remove shells and solids from selection
    simlab.deselect(); 
    SelectBodyByType=''' <SelectBodyByType UUID="b93aad23-5061-485b-b061-447f8d9cf924">
      <ModelName Value="'''+RBEModel+'''"/>
      <BodyType Value="RBE"/>
     </SelectBodyByType>''';
    simlab.execute(SelectBodyByType);
    AllRBEArray=simlab.getSelectedBodies();
    RBEArray = tuple(x for x in RBEArray if x in AllRBEArray)
    RBEBodyStrInput=str(RBEArray).replace("'",'"').strip("()");
        
    ########Checks
    if len(RBEArray) <= 0:
        simlab.messageBox.popupmsg("Please select RBE Bodies");
        return;
    MaxRBE=200; 
    if EquivFlag=='true':
        MaxRBE=100
        
    if len(RBEArray) > MaxRBE:
        MessageBox = simlab.pauseprocess("The conversion of RBEs could require a  long time. \nConsider merging the RBE Bodies and/or using the 'Quick RBE Springs' tool." ,title="Warning",Button1="Continue anyway ",Button2="Quit");
        if MessageBox.status == False:
            return;    

    ######## ORGANIZE#######################
    ####Create destination subssembly
    CreateSubModelQuuid=''' <CreateSubModelQuuid UUID="e9d719a4-0e49-42a2-9973-15acab8ab987">
      <SubModelName Value="Converted_RBEs"/>
      <ModelName Value="'''+RBEModel+'''"/>
      <ParentSubModelName Value=""/>
     </CreateSubModelQuuid>''';
    simlab.execute(CreateSubModelQuuid);
    ##Temporary subassembly 
    CreateSubModelQuuid=''' <CreateSubModelQuuid UUID="e9d719a4-0e49-42a2-9973-15acab8ab987">
      <SubModelName Value="CurrentRBE_sub"/>
      <ModelName Value="'''+RBEModel+'''"/>
      <ParentSubModelName Value=""/>
     </CreateSubModelQuuid>''';
    simlab.execute(CreateSubModelQuuid);
    
    #Moves all bodies to subassembly
    MoveToSubModelQuuid=''' <MoveToSubModelQuuid UUID="475fe1b6-1656-44e3-9e36-2656ed16de0c">
      <SubModelName Value="CurrentRBE_sub"/>
      <BodiesToMove>
       <Entities>
        <Model>'''+RBEModel+'''</Model>
        <Body>"'''+RBEBodyStrInput+'''",</Body>
       </Entities>
      </BodiesToMove>
     </MoveToSubModelQuuid>''';
    simlab.execute(MoveToSubModelQuuid); 
      
    
    ########EQUIVALENCING: Stitch by equivalence node,i-based, i.e. based on input RBEs (still merged)
    
    if EquivFlag=='true':
        # Detect non-RBE bodies for equivalencing
        AllBodyArray = simlab.getChildrenInAssembly(RBEModel,RBEModel,"ALLBODIES");
        AllBodyArray = tuple(item for item in AllBodyArray if item not in AllRBEArray) 
        for i in range(0, len(RBEArray)):
            ##Pick all all bodies already connected to current RBE[i] to avoid node collapse
            SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
              <InputBodies>
               <Entities>
                <Model>'''+RBEModel+'''</Model>
                <Body>"'''+RBEArray[i]+'''",</Body>
               </Entities>
              </InputBodies>
              <AssociatedEntities Type="ConnectedBodies" SubType="Solid_Shell,"/>
              <Groupname Value="BodiesConnectedToRBE"/>
             </SelectBodyAssociatedEntities>''';
            simlab.execute(SelectBodyAssociatedEntities); 
            BodiesConnectedToRBE = simlab.getBodiesFromGroup('BodiesConnectedToRBE');
            BodyToConnect=tuple(item for item in AllBodyArray if item not in BodiesConnectedToRBE)
            DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
              <tag Value="-1"/>
              <Name Value="BodiesConnectedToRBE,"/>
              <Output/>
             </DeleteGroupControl>''';
            simlab.execute(DeleteGroupControl);
            for j in range(0, len(BodyToConnect)):
                BodyAndRBE=(RBEArray[i],BodyToConnect[j])
                BodyAndRBEString=str(BodyAndRBE).replace("'",'"').strip("()");
                SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
                  <ParamInfo Type="length" Value="'''+Tolerance+'''" Name="Tolerance"/>
                 </Parameters>''';
                simlab.execute(SimLabParameters);
                EquivalenceNodes=''' <FemNodeEquivalence UUID="7a5431cd-a2da-4f61-b8ef-9abf3306dd0c">
                  <tag Value="-1"/>
                  <Name Value="FemNodeEquivalence1"/>
                  <SupportEntities>
                   <Entities>
                    <Model>'''+RBEModel+'''</Model>
                    <Body>"'''+BodyAndRBEString+'''",</Body>
                   </Entities>
                  </SupportEntities>
                  <FaceNodes Value="0"/>
                  <EdgeNodes Value="0"/>
                  <VertexNodes Value="0"/>
                  <RBERadialNodes Value="1"/>
                  <SingleBody Value="0"/>
                  <RBECenterBarFreeNode Value="0"/>
                  <SmallerNodeId Value="1"/>
                  <LargerNodeId Value="0"/>
                  <ToMidPosition Value="0"/>
                  <Tolerance Value="$Tolerance"/>
                  <Show Value="" Clicked="0"/>
                  <RBECenterOrphanNodeMass Value="0"/>
                  <PreserverRbePos Value="1"/>
                  <PreserverRbeID Value="1"/>
                  <Output/>
                 </FemNodeEquivalence>''';
                simlab.execute(EquivalenceNodes);                  

                ############END OF NODE EQUIVALENCING ##########################

    
    #i-loop through all input bodies
    for i in range(0, len(RBEArray)):
        ####UNMERGE Body if it CONTAINS DIFFERENT RBEs#
        UnmergeBody=''' <UnMerge gda="" UUID="B4A72790-34D2-4ac0-9820-84ED4F33E27E">
          <tag Value="-1"/>
          <Name Value=""/>
          <SupportEntities>
           <Entities>
            <Model>'''+RBEModel+'''</Model>
            <Body>"'''+RBEArray[i]+'''",</Body>
           </Entities>
          </SupportEntities>
          <RedoFlag Value=""/>
          <Output/>
         </UnMerge>''';
        simlab.execute(UnmergeBody);
        #New String with unmerged body list from [i] body
        BodyList2 = simlab.getChildrenInAssembly(RBEModel, "CurrentRBE_sub","ALLBODIES");
        CurrentRBEArray = tuple(item for item in BodyList2 if item not in RBEArray or item == RBEArray[i]);
        CurrentRBEStr=str(CurrentRBEArray).replace("'",'"').strip("()"); 
        
        ##Reset of Node sets and Node list for spring creation
        DeleteLBCControl=''' <DeleteLBCControl CheckBox="ON" UUID="b37a621e-e984-4cee-a307-3a80317852ae">
          <Output/>
          <Name Type="Node Set" Value="Spring_Set_1"/>
          <Name Type="Node Set" Value="Spring_Set_2"/>
         </DeleteLBCControl>''';
        simlab.execute(DeleteLBCControl);
        Set1List = [];
        Set2List = [];
        

        
        
        #j-loop through the single RBE that were unmerged from [i]
        for j in range(len(CurrentRBEArray)):            
            ##EQUIVALENCING Stitch by equivalence node,j-based, i.e. based on unmerged RBEs
            if EquivFlag=='true':
                ###Pick all all bodies already connected to current RBE[j] to avoid node collapse
                ### This seems to take too long. Probably better if i-based.
                ## Ideally, full i-rbe connected to j-based solid if not already connected
                SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
                  <InputBodies>
                   <Entities>
                    <Model>'''+RBEModel+'''</Model>
                    <Body>"'''+CurrentRBEArray[j]+'''",</Body>
                   </Entities>
                  </InputBodies>
                  <AssociatedEntities Type="ConnectedBodies" SubType="Solid_Shell,"/>
                  <Groupname Value="BodiesConnectedToRBE"/>
                 </SelectBodyAssociatedEntities>''';
                simlab.execute(SelectBodyAssociatedEntities);                
                
                BodiesConnectedToRBE = simlab.getBodiesFromGroup('BodiesConnectedToRBE');
                DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
                  <tag Value="-1"/>
                  <Name Value="BodiesConnectedToRBE,"/>
                  <Output/>
                 </DeleteGroupControl>''';
                simlab.execute(DeleteGroupControl);
                AllBodyAndRBE=tuple(item for item in AllBodyArray if item not in BodiesConnectedToRBE)+ (CurrentRBEArray[j],)
                AllBodyAndRBEString=str(AllBodyAndRBE).replace("'",'"').strip("()");
                SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
                  <ParamInfo Type="length" Value="'''+Tolerance+'''" Name="Tolerance"/>
                 </Parameters>''';
                simlab.execute(SimLabParameters);
                EquivalenceNodes=''' <FemNodeEquivalence UUID="7a5431cd-a2da-4f61-b8ef-9abf3306dd0c">
                  <tag Value="-1"/>
                  <Name Value="FemNodeEquivalence1"/>
                  <SupportEntities>
                   <Entities>
                    <Model>'''+RBEModel+'''</Model>
                    <Body>"'''+AllBodyAndRBEString+'''",</Body>
                   </Entities>
                  </SupportEntities>
                  <FaceNodes Value="0"/>
                  <EdgeNodes Value="0"/>
                  <VertexNodes Value="0"/>
                  <RBERadialNodes Value="1"/>
                  <SingleBody Value="0"/>
                  <RBECenterBarFreeNode Value="0"/>
                  <SmallerNodeId Value="1"/>
                  <LargerNodeId Value="0"/>
                  <ToMidPosition Value="0"/>
                  <Tolerance Value="$Tolerance"/>
                  <Show Value="" Clicked="0"/>
                  <RBECenterOrphanNodeMass Value="0"/>
                  <PreserverRbePos Value="1"/>
                  <PreserverRbeID Value="1"/>
                  <Output/>
                 </FemNodeEquivalence>''';
                simlab.execute(EquivalenceNodes);                  

                ############END OF NODE EQUIVALENCING ##########################


            ######BUSH####### j-based, node based
            if ConnectorType=="Bush":      
                DeleteGroupControl=''' <DeleteGroupControl UUID="2a3b5834-9708-4b03-871c-6d05623667bd" CheckBox="ON">
                  <tag Value="-1"/>
                  <Name Value="RBE_Nodes,"/>
                  <Output/>
                 </DeleteGroupControl>''';
                simlab.execute(DeleteGroupControl);                
                SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
                  <InputBody Values="">
                   <Entities>
                    <Model>'''+RBEModel+'''</Model>
                    <Body>"'''+CurrentRBEArray[j]+'''",</Body>
                   </Entities>
                  </InputBody>
                  <Option Value="Nodes"/>
                  <Groupname Value="RBE_Nodes"/>
                  <RBECenterNode Value="0"/>
                  <RBEDependantNodes Value="1"/>
                 </SelectBodyAssociatedEntities>''';
                simlab.execute(SelectBodyAssociatedEntities);
                NodeIdArray = simlab.getEntityFromGroup('RBE_Nodes');
                SpringCurrentName=CurrentRBEArray[j];
                #<AxisId Value="Global" Index="0"/>
                if len(NodeIdArray)==2:
                    BushElement=''' <Bush BCType="Bush" UUID="64BCE25D-CFFF-409e-9007-09B89A22D1E9">
                      <tag Value="-1"/>
                      <Name Value="'''+SpringCurrentName+'''"/>
                      <SupportEntities>
                       <Entities>
                        <Model>'''+RBEModel+'''</Model>
                        <Node>'''+str(NodeIdArray[0])+''','''+str(NodeIdArray[1])+''',</Node>
                       </Entities>
                      </SupportEntities>
                      <GroundSpring Value="0"/>
                      <AxisId Index="1" Value="'''+CS+'''"/>
                      <Between Index="0" Value="Two Nodes"/>
                      <GlobalDamping Check="0" Value="0" FieldName=""/>
                      <XSpringDisp Check="1" SprTyp="USER_DEF" Value="'''+DxStiff+'''" FieldName="none"/>
                      <YSpringDisp Check="1" SprTyp="USER_DEF" Value="'''+DyStiff+'''" FieldName="none"/>
                      <ZSpringDisp Check="1" SprTyp="USER_DEF" Value="'''+DzStiff+'''" FieldName="none"/>
                      <XSpringRot Check="1" SprTyp="USER_DEF" Value="'''+RxStiff+'''" FieldName="none"/>
                      <YSpringRot Check="1" SprTyp="USER_DEF" Value="'''+RyStiff+'''" FieldName="none"/>
                      <ZSpringRot Check="1" SprTyp="USER_DEF" Value="'''+RzStiff+'''" FieldName="none"/>
                      <XDamperDisp Check="" Value="" FieldName="none"/>
                      <YDamperDisp Check="" Value="" FieldName="none"/>
                      <ZDamperDisp Check="" Value="" FieldName="none"/>
                      <XDamperRot Check="" Value="" FieldName="none"/>
                      <YDamperRot Check="" Value="" FieldName="none"/>
                      <ZDamperRot Check="" Value="" FieldName="none"/>
                      <DX Mass="" MassFreqTableName="none" StructuralDampingConst="" ForceDeflectionTableName="none" StructDampFreqTableName="none"/>
                      <DY Mass="" MassFreqTableName="none" StructuralDampingConst="" ForceDeflectionTableName="none" StructDampFreqTableName="none"/>
                      <DZ Mass="" MassFreqTableName="none" StructuralDampingConst="" ForceDeflectionTableName="none" StructDampFreqTableName="none"/>
                      <RX Mass="" MassFreqTableName="none" StructuralDampingConst="" ForceDeflectionTableName="none" StructDampFreqTableName="none"/>
                      <RY Mass="" MassFreqTableName="none" StructuralDampingConst="" ForceDeflectionTableName="none" StructDampFreqTableName="none"/>
                      <RZ Mass="" MassFreqTableName="none" StructuralDampingConst="" ForceDeflectionTableName="none" StructDampFreqTableName="none"/>
                     </Bush>''';
                    simlab.execute(BushElement); 

            ######SPRING - set creation, j-based############
            if ConnectorType=="Spring": 
 
                SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
                  <InputBody Values="">
                   <Entities>
                    <Model>'''+RBEModel+'''</Model>
                    <Body>"'''+CurrentRBEArray[j]+'''",</Body>
                   </Entities>
                  </InputBody>
                  <Option Value="Nodes"/>
                  <Groupname Value="RBE_Nodes"/>
                  <RBECenterNode Value="0"/>
                  <RBEDependantNodes Value="1"/>
                 </SelectBodyAssociatedEntities>''';
                simlab.execute(SelectBodyAssociatedEntities);
                NodeIdArrayRBE = simlab.getEntityFromGroup('RBE_Nodes');
                Set1List.append (NodeIdArrayRBE[0]);
                Set2List.append (NodeIdArrayRBE[1]);
                              
             #All duplicate nodes must go to Set2List if possible. There is no check for errors.
        if ConnectorType=="Spring":
            for j in range(len(Set1List)):  
                if Set1List[j] in Set1List[:j] or Set1List[j] in Set1List[j+1:] or Set1List[j] in Set2List:
                    # Swap Set1List[j] with its corresponding Set2List[j]
                    Set1List[j], Set2List[j] = Set2List[j], Set1List[j]
            #End of J-loops
       
                    
        ### Spring greation by set, i-based
        if ConnectorType=="Spring":
            Set1List = tuple(Set1List)
            Set2List = tuple(Set2List)
            Set1String=str(Set1List).strip("()");
            Set2String=str(Set2List).strip("()");
            #SetID Value removed from set command to avoid conflicts
            Sets=''' <SetsDlg CheckBox="ON" UUID="c54659af-2627-4c1a-b516-f5312356c88d" customselection="1" BCType="Sets" isObject="2" pixmap="sets">
              <tag Value="-1"/>
              <Name Value="Spring_Set_1"/>
              <SetID Value=""/>
              <SetstEntities>
               <Entities>
                <Model>'''+RBEModel+'''</Model>
                <Node>'''+Set1String+ '''</Node>
               </Entities>
              </SetstEntities>
              <masterSupportEntities EntityTypes="" ModelIds="" Value=""/>
              <slaveSupportEntities EntityTypes="" ModelIds="" Value=""/>
              <SetType Value="Node"/>
              <EntityType Value="Node"/>
              <EntityID Value=""/>
              <nodeaset Value=""/>
              <nodeaset1 Value=""/>
              <one Value=""/>
              <two Value=""/>
              <three Value=""/>
              <four Value=""/>
              <five Value=""/>
              <six Value=""/>
              <LinearCheck Value=""/>
              <TabIndex Value=""/>
              <Tolerance Value=""/>
              <ContactFaceIndex Value=""/>
              <TrimOption Value="-1"/>
              <MasterSetName Value=""/>
              <SlaveSetName Value=""/>
              <SetTypeIndex Value=""/>
              <MapEntities Value=""/>
              <MeshCtrlCheck Value=""/>
              <SetCtrlCheck Value=""/>
              <GrpCtrlCheck Value=""/>
              <Options Value=""/>
              <CadModelCheck Value=""/>
              <MaxId Value=""/>
              <MinId Value=""/>
              <AxisID Value=""/>
              <RegionType Value="0"/>
              <RegionX Value="0.0"/>
              <RegionY Value="0.0"/>
              <RegionZ Value="0.0"/>
              <Node_IncMidNodes Value="1"/>
              <SurfNodes Value="0"/>
              <IncSolidElemIsAttachFaceNodes Value=""/>
              <NumSolidElemLayers Value=""/>
              <IsRegionType Value="-1"/>
              <IsRegionDefined Value="-1"/>
              <RegnOption Value="-1"/>
              <MemLayerConnMidNodesCheck Value=""/>
              <ReducedIntegrationMembraneElements Value=""/>
              <Output/>
             </SetsDlg>''';
            simlab.execute(Sets);
            Sets=''' <SetsDlg CheckBox="ON" UUID="c54659af-2627-4c1a-b516-f5312356c88d" customselection="1" BCType="Sets" isObject="2" pixmap="sets">
              <tag Value="-1"/>
              <Name Value="Spring_Set_2"/>
              <SetID Value=""/>
              <SetstEntities>
               <Entities>
                <Model>'''+RBEModel+'''</Model>
                <Node>'''+Set2String+'''</Node>
               </Entities>
              </SetstEntities>
              <masterSupportEntities EntityTypes="" ModelIds="" Value=""/>
              <slaveSupportEntities EntityTypes="" ModelIds="" Value=""/>
              <SetType Value="Node"/>
              <EntityType Value="Node"/>
              <EntityID Value=""/>
              <nodeaset Value=""/>
              <nodeaset1 Value=""/>
              <one Value=""/>
              <two Value=""/>
              <three Value=""/>
              <four Value=""/>
              <five Value=""/>
              <six Value=""/>
              <LinearCheck Value=""/>
              <TabIndex Value=""/>
              <Tolerance Value=""/>
              <ContactFaceIndex Value=""/>
              <TrimOption Value="-1"/>
              <MasterSetName Value=""/>
              <SlaveSetName Value=""/>
              <SetTypeIndex Value=""/>
              <MapEntities Value=""/>
              <MeshCtrlCheck Value=""/>
              <SetCtrlCheck Value=""/>
              <GrpCtrlCheck Value=""/>
              <Options Value=""/>
              <CadModelCheck Value=""/>
              <MaxId Value=""/>
              <MinId Value=""/>
              <AxisID Value=""/>
              <RegionType Value="0"/>
              <RegionX Value="0.0"/>
              <RegionY Value="0.0"/>
              <RegionZ Value="0.0"/>
              <Node_IncMidNodes Value="1"/>
              <SurfNodes Value="0"/>
              <IncSolidElemIsAttachFaceNodes Value=""/>
              <NumSolidElemLayers Value=""/>
              <IsRegionType Value="-1"/>
              <IsRegionDefined Value="-1"/>
              <RegnOption Value="-1"/>
              <MemLayerConnMidNodesCheck Value=""/>
              <ReducedIntegrationMembraneElements Value=""/>
              <Output/>
             </SetsDlg>''';
            simlab.execute(Sets);        
            SpringCurrentName=RBEArray[i]; 
            SN1="Spring_Set_1";
            SN2="Spring_Set_2";
            #Note: Set-Based spring creation is not supported in GUI
            SpringElement=''' <Spring CheckBox="ON" UUID="ACA1CCC4-4687-41bd-9BA3-0C602C5B2B7D" isObject="2" BCType="Spring">
              <tag Value="-1"/>
              <Name Value="'''+SpringCurrentName+'''"/>
              <SpringEntities>
               <Entities>
                <Model>'''+RBEModel+'''</Model>
                <Node>'''+SN1+","+SN2+'''</Node>
               </Entities>
              </SpringEntities>
              <ElementID Value="0"/>
              <AxisID Value="'''+CS+'''"/>
              <FieldID Value=""/>
              <Type Value="Nodes" Index="0"/>
              <SpringType Value="1"/>
              <PropertyID Value="0"/>
              <TXStiff CheckBox="0" Value="'''+DxStiff+'''"/>
              <TYStiff CheckBox="0" Value="'''+DyStiff+'''"/>
              <TZStiff CheckBox="0" Value="'''+DzStiff+'''"/>
              <RXStiff CheckBox="0" Value="'''+RxStiff+'''"/>
              <RYStiff CheckBox="0" Value="'''+RyStiff+'''"/>
              <RZStiff CheckBox="0" Value="'''+RzStiff+'''"/>
              <Flag1 Value="'''+str(SpringFlag)+'''"/>
              <Flag2 Value="0"/>
              <GndSpring Value="0"/>
              <IgnoreMidnodes Value="0"/>
              <FieldData Value="None" Index="0"/>
              <RadiossExp>
               <Mass Value=""/>
               <Inertia Value=""/>
               <Stiffness_Table_TX Value=""/>
               <Stiffness_Table_TY Value=""/>
               <Stiffness_Table_TZ Value=""/>
               <Stiffness_Table_RX Value=""/>
               <Stiffness_Table_RY Value=""/>
               <Stiffness_Table_RZ Value=""/>
              </RadiossExp>
             </Spring>''';
            simlab.execute(SpringElement);  
            
        #in i-loop, re-merge RBE
        MergeBodies=''' <BodyMerge gda="" UUID="FA9128EE-5E6C-49af-BADF-4016E5622020">
          <tag Value="-1"/>
          <Name Value="BodyMerge3"/>
          <SupportEntities>
           <Entities>
            <Model>'''+RBEModel+'''</Model>
            <Body>'''+CurrentRBEStr+'''</Body>
           </Entities>
          </SupportEntities>
          <Delete_Shared_Faces Value="0"/>
          <Output_Body_Name Value="'''+RBEArray[i]+'''"/>
          <RedoFlag Value=""/>
          <Output/>
         </BodyMerge>''';
        simlab.execute(MergeBodies);
        
        DeleteGroupControl=''' <DeleteGroupControl UUID="2a3b5834-9708-4b03-871c-6d05623667bd" CheckBox="ON">
          <tag Value="-1"/>
          <Name Value="RBE_Nodes,"/>
          <Output/>
         </DeleteGroupControl>''';
        simlab.execute(DeleteGroupControl);
        
    ########end of i-loop ################## 
    ####Move re-merged RBEs
    MoveToSubModelQuuid=''' <MoveToSubModelQuuid UUID="475fe1b6-1656-44e3-9e36-2656ed16de0c">
      <SubModelName Value="Converted_RBEs"/>
      <BodiesToMove>
       <Entities>
        <Model>'''+RBEModel+'''</Model>
        <Body>"'''+RBEBodyStrInput+'''",</Body>
       </Entities>
      </BodiesToMove>
     </MoveToSubModelQuuid>''';
    simlab.execute(MoveToSubModelQuuid);        
    
    DeleteSubModelQuuid=''' <DeleteSubModelQuuid UUID="4300302f-0622-4ea2-92c9-777d84432b3c">
      <SubModelName Value="CurrentRBE_sub"/>
      <ModelName Value="'''+RBEModel+'''"/>
     </DeleteSubModelQuuid>''';
    simlab.execute(DeleteSubModelQuuid);
                 
    DeleteLBCControl=''' <DeleteLBCControl UUID="b37a621e-e984-4cee-a307-3a80317852ae" CheckBox="ON">
      <Output/>
      <Name Value="Spring_Set_1" Type="Node Set"/>
      <Name Value="Spring_Set_2" Type="Node Set"/>
     </DeleteLBCControl>''';
    simlab.execute(DeleteLBCControl);
   
    DeleteGroupControl=''' <DeleteGroupControl UUID="2a3b5834-9708-4b03-871c-6d05623667bd" CheckBox="ON">
      <tag Value="-1"/>
      <Name Value="RBE_Nodes,InputBodyGroup,"/>
      <Output/>
     </DeleteGroupControl>''';
    simlab.execute(DeleteGroupControl);
    
    HideList = simlab.getChildrenInAssembly(RBEModel, "Converted_RBEs","ALLBODIES");
    if len(RBEArray)>0:
        simlab.showOrHideEntities(HideList, "Hide", RBEModel, "Body");

        

################MAIN PROGRAM#######################

main();


    
    
    
    
