#Edit Holes, Cones and Cylinders - v4.0- SL v2022.3
#Author: Librandi - Altair Germany 

#******************************************

from hwx import simlab

#Custom Dialog in SimLab creates two variables:
# EntityIds (Face Selection) 
# newRadius (Radius input from user)


simlab.setSelectionFilter("CylinderFace");
print("Edit Holes.......")
#Create Float Variable newRadius from text input.
newRadius = float(newRadius);
#.........
#Get Selected Entities: not needed when using Custom GUI in SL
#EntityIds=simlab.getSelectedEntities("Face")

#Identify GDA model name.	
OutModelName=simlab.getParentModelFromSelectedEntities("Face");
	
#Check: faces not selected	
if len(EntityIds) <= 0:
	simlab.messageBox.popupmsg("Please select cone or cylinder faces.")
	#exit();
else:
	DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
	  <tag Value="-1"/>
	  <Name Value="EditHole_FAILED,"/>
	  <Output/>
	 </DeleteGroupControl>''';
	simlab.execute(DeleteGroupControl);
#Create Group with selected entities		
	CreateGroup=''' <CreateGroup CheckBox="OFF" isObject="4" UUID="899db3a6-bd69-4a2d-b30f-756c2b2b1954">
	  <tag Value="-1"/>
	  <Name OldValue="" Value="EditHole_FAILED"/>
	  <SupportEntities>
	   <Entities>
		<Model>'''+OutModelName+'''</Model>
		<Face>''' + str(EntityIds).strip('()') + '''</Face>
	   </Entities>
	  </SupportEntities>
	  <Type Value="Face"/>
	  <Color Value="255,0,255,"/>
	  <Dup Value="0"/>
	 </CreateGroup>''';
	simlab.execute(CreateGroup);
					
DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
	  <tag Value="-1"/>
	  <Name Value="EditHole_DONE,"/>
	  <Output/>
	 </DeleteGroupControl>''';
simlab.execute(DeleteGroupControl);
#Copy Group 		
EntityIdArray= simlab.getEntityFromGroup('EditHole_FAILED')
CreateGroup=''' <CreateGroup CheckBox="OFF" isObject="4" UUID="899db3a6-bd69-4a2d-b30f-756c2b2b1954">
		  <tag Value="-1"/>
		  <Name OldValue="" Value="EditHole_Done"/>
		  <SupportEntities>
		   <Entities>
			  <Model>'''+OutModelName+'''</Model>
			  <Face>''' + str(EntityIdArray).strip('()') + '''</Face>
		   </Entities>
		  </SupportEntities>
		  <Type Value="Face"/>
		  <Color Value="255,0,255,"/>
		  <Dup Value="0"/>
		 </CreateGroup>''';
simlab.execute(CreateGroup);
#Create Holes groups by connected entities
FaceGroupNames=simlab.createGroupsOfConnectedEntities("EditHole_FAILED")

#Messages to Python Window for debugging
print("Model:",OutModelName)
print("Faces:",len(EntityIds))
print("Holes:",len(FaceGroupNames))

#Align group holes in sequence
FailedPatchCheck = 0
for i in range(len(FaceGroupNames)):
	try:
		AxPt1,AxPt2,MinRad,MaxRad=simlab.getConicalFaceAttributes(FaceGroupNames[i])
	except:
	#Search for Conical Attributes in the single faces of the Patch
		PatchFacesIDs= simlab.getEntityFromGroup(FaceGroupNames[i])
		LoopExitCheck = 0
		for j in range(len(PatchFacesIDs)):
				try:
					AxPt1,AxPt2,MinRad,MaxRad=simlab.getConicalFaceAttributes(OutModelName,PatchFacesIDs[j])
					LoopExitCheck = 1
					break
				except:
					continue
		if LoopExitCheck == 0:
			FailedPatchCheck = 1 #If patch could not be fixed, faces are removed from group
			BooleanGroup=''' <BooleanGroup UUID="5da8b41c-208b-4968-a282-9763c2258878">
			  <tag Value="-1"/>
			  <Name Value="Diff_3"/>
			  <Type Value="Face"/>
			  <UseExtisingGroup Value="EditHole_Done"/>
			  <Operation Value="Difference"/>
			  <GroupList1 Value="EditHole_Done,"/>
			  <GroupList2 Value="'''+str(FaceGroupNames[i])+'''"/>
			 </BooleanGroup>''';
			simlab.execute(BooleanGroup);
			continue	
	if newRadius <= 0:
		Radius = max(MinRad[0],MaxRad[0]);
	else:
		Radius=newRadius;		
	AlignCylinder=''' <AlignCylinder CheckBox="ON" UUID="5D271AC4-A0CE-411f-9E60-E7B17CB8B1B7">
	  <tag Value="-1"/>
	  <Name Value=""/>
	  <Entities>
	   <Group>"'''+str(FaceGroupNames[i])+'''",</Group>
	  </Entities>
	  <Axis Point1="'''+str(AxPt1).strip('()') + '''" Point2="''' + str(AxPt2).strip('()') +'''" Value="Select"/>
	  <Radius Value="'''+str(Radius)+'''"/>
	  <ProjectMidNodes Value="1"/>
	  <EntityType Value="1"/>
	 </AlignCylinder>''';
	simlab.execute(AlignCylinder);
	
	DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
		  <tag Value="-1"/>
		  <Name Value="'''+str(FaceGroupNames[i])+'''"/>
		  <Output/>
		 </DeleteGroupControl>''';
	simlab.execute(DeleteGroupControl); 
#Message if some face failed
#root.destroy()
if FailedPatchCheck == 1:
	simlab.popupmsg("Not fixed faces added to EditHoles_FAILED group.")	
	
