#***************************************************************
#SimLab Version 2021 Beta
#Created at Mon Jan 25 2021
# Update to v 2025 by Alessio Librandi
#***************************************************************

from hwx import simlab

import os
import numpy as np

#abspath = os.path.abspath(__file__)
#scriptDir = os.path.dirname(abspath)
#os.chdir(scriptDir)

def getModelFromBody(BodyName):
    #This function accepts a body name and returns the model to which this body belongs
    OutModelNames = simlab.getAllRootModelNames("FEM")
    for i in range(0, len(OutModelNames)):
        OutputList = simlab.getChildrenInAssembly(OutModelNames[i], OutModelNames[i],"ALLBODIES")
        for j in range(0, len(OutputList)):
            if(OutputList[j]==BodyName):
                result = OutModelNames[i]
    return result

def distanceBetweenCenters(Center1, Center2):
    distance = 0
    for i in range(0, len(Center1)):
        distance = distance + (Center1[i]-Center2[i])**2
    return distance

def closestNodes(ModelName, NodeArr1, NodeArr2):
    MinNodeArr = []
    for Node1 in NodeArr1:
        i = 0
        Loc1 = simlab.getNodePositionFromNodeID(ModelName,Node1)
        minDistance = 0
        minNode = -1
        for Node2 in NodeArr2:
            if(Node2 not in MinNodeArr):
                Loc2 = simlab.getNodePositionFromNodeID(ModelName,Node2)
                distance = distanceBetweenCenters(Loc1, Loc2)
                if (distance < minDistance) or (i==0):
                    minDistance = distance
                    minNode = Node2
                i = i+1
        MinNodeArr.append(minNode)
    return MinNodeArr

def createSection(ModelName, Node1, Node2, NumberOfSections):
    Loc1 = simlab.getNodePositionFromNodeID(ModelName,Node1)
    Loc2 = simlab.getNodePositionFromNodeID(ModelName,Node2)
    NodeArr = []
    LocArr = []
    NodeArr.append(Node1)
    LocArr.append(Loc1)
    
    for Section in range(1, NumberOfSections):
        NodeLoc = np.zeros(3)
        for i in range(0, 3):
            #This formula was fixed in v2025
            NodeLoc[i] = ((NumberOfSections-Section)*Loc1[i] + Section*Loc2[i])/NumberOfSections
        
        NodeID=simlab.getNextNodeID(ModelName)
        
        NodeByXYZ=''' <NodeByXYZ UUID="F200B5A2-D615-4d01-8DE2-25596B3B1EB8">
          <tag Value="-1"/>
          <Name Value=""/>
          <LocalCoordinateSystem Value="0"/>
          <Position Value="'''+str(NodeLoc[0])+''','''+str(NodeLoc[1])+''','''+str(NodeLoc[2])+'''"/>
          <Node Value="'''+str(NodeID)+'''"/>
          <UniqueNodeId Value="0"/>
          <ModelName Value="'''+ModelName+'''"/>
         </NodeByXYZ>''';
        simlab.execute(NodeByXYZ);
        
        NodeArr.append(NodeID)
        LocArr.append(NodeLoc)
    
    NodeArr.append(Node2)
    LocArr.append(Loc2)
        
    return NodeArr, LocArr

#debug
if 0==1:
    RBE_top = "RBE2_2A"
    RBE_bottom = "RBE2_2B"
    BarName = "RBEBars"
    MaterialName = "9121111"
    NumberOfSections = 3 
    Radius = 5
    Density = 7.8e-09
    YoungModulus = 208000
    PoissonsRatio = 0.3
    DampingCoeff = 0.04
    PropType = "BAR"


RBE_top = RBE_top.strip(',')
RBE_top = RBE_top.strip('"')
RBE_bottom = RBE_bottom.strip(',')
RBE_bottom = RBE_bottom.strip('"')

ModelNameRBE = getModelFromBody(RBE_top)
PropertyName = MaterialName
NumberOfSections = int(NumberOfSections)



# Creates node groups from center nodes of RBEs
SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
  <InputBody Values="">
   <Entities>
    <Model>'''+ModelNameRBE+'''</Model>
    <Body>"'''+RBE_top+'''",</Body>
   </Entities>
  </InputBody>
  <Option Value="Nodes"/>
  <Groupname Value="CenterNodes_top"/>
  <RBECenterNode Value="1"/>
  <RBEDependantNodes Value="0"/>
 </SelectBodyAssociatedEntities>''';
simlab.execute(SelectBodyAssociatedEntities);

SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
  <InputBody Values="">
   <Entities>
    <Model>'''+ModelNameRBE+'''</Model>
    <Body>"'''+RBE_bottom+'''",</Body>
   </Entities>
  </InputBody>
  <Option Value="Nodes"/>
  <Groupname Value="CenterNodes_bottom"/>
  <RBECenterNode Value="1"/>
  <RBEDependantNodes Value="0"/>
 </SelectBodyAssociatedEntities>''';
simlab.execute(SelectBodyAssociatedEntities);

CenterNodes_top = simlab.getEntityFromGroup('CenterNodes_top')
CenterNodes_bottom = simlab.getEntityFromGroup('CenterNodes_bottom')
MinArr = closestNodes(ModelNameRBE, CenterNodes_top, CenterNodes_bottom)

MergeName = ""
beamCount = 0
for i in range(0, len(CenterNodes_top)):
    Node1 = CenterNodes_top[i]
    Node2 = MinArr[i]

    NodeIDArr, NodeLocArr = createSection(ModelNameRBE, Node1, Node2, NumberOfSections)

    for j in range(0, len(NodeIDArr)-1):
        FirstNode = NodeIDArr[j]
        SecondNode = NodeIDArr[j+1]

        CreateBar=''' <Bar CheckBox="ON" UUID="741D7A3A-1CD4-4051-ABBA-CD1603D1C545">
          <tag Value="-1"/>
          <Name Value="'''+BarName+str(beamCount)+'''"/>
          <SupportEntities>
           <Entities>
            <Model>'''+ModelNameRBE+'''</Model>
            <Node>'''+str(FirstNode)+''','''+str(SecondNode)+''',</Node>
           </Entities>
          </SupportEntities>
          <Output/>
         </Bar>''';
        simlab.execute(CreateBar);

        MergeName = MergeName + "\"" + BarName + str(beamCount) + "\"" + ","
        
        beamCount = beamCount+1

BodyMergeRightClick=''' <BodyMergeRightClick CheckBox="ON" UUID="7d2fbe6f-4dd7-4848-8cb5-f8be2d72c418">
  <tag Value="-1"/>
  <ModelId Value=""/>
  <BodyId>
   <Entities>
    <Model>'''+ModelNameRBE+'''</Model>
    <Body>"'''+MergeName+'''",</Body>
   </Entities>
  </BodyId>
  <RedoFlag Value=""/>
  <Output/>
 </BodyMergeRightClick>''';
simlab.execute(BodyMergeRightClick);

########################################################################################################
if CreateMaterial == 'true':
    Material=''' <Material Auto="1" UUID="dd7920e8-5d0f-477b-bc7e-037a04a7ed03">
      <tag Value="'''+MaterialName+'''"/>
      <Name Value="'''+MaterialName+'''"/>
      <MaterialId Value="'''+MaterialName+'''"/>
      <Category Value="Solid"/>
      <Class Value="Metal"/>
      <Model UnitSystem="" Value="Isotropic"/>
      <SupportEntities/>
      <TableData>
       <Mechanical_Properties>
        <Elastic>
         <ITEM DISPLAYNAME="Density" KEY="Density">
          <COLUMN DATATYPE="DOUBLE" VALUE="'''+Density+'''"/>
          <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM DISPLAYNAME="Youngs_modulus" KEY="Youngs_modulus">
          <COLUMN DATATYPE="DOUBLE" VALUE="'''+YoungModulus+'''"/>
          <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM DISPLAYNAME="Poissons_ratio" KEY="Poissons_ratio">
          <COLUMN DATATYPE="DOUBLE" VALUE="'''+PoissonsRatio+'''"/>
          <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM DISPLAYNAME="Shear_modulus" KEY="Shear_modulus"/>
         <ITEM DISPLAYNAME="Thermal_Expansion" KEY="Thermal_Expansion">
          <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM DISPLAYNAME="Reference_Temperature" KEY="Reference_Temperature"/>
         <ITEM DISPLAYNAME="Damping_coefficient" KEY="Damping_coefficient">
          <COLUMN DATATYPE="DOUBLE" VALUE="'''+DampingCoeff+'''"/>
         </ITEM>
         <ITEM DISPLAYNAME="Stress_Tension" KEY="Stress_Tension"/>
         <ITEM DISPLAYNAME="Stress_Compression" KEY="Stress_Compression"/>
         <ITEM DISPLAYNAME="Stress_Shear" KEY="Stress_Shear"/>
         <ITEM DISPLAYNAME="Mat_Cord_Sys" KEY="Mat_Cord_Sys"/>
        </Elastic>
        <Plastic>
         <ITEM DISPLAYNAME="Yield stress-strain table" KEY="Yield_Stress">
          <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM DISPLAYNAME="Work hardening slope" KEY="Work_Hardening_Slope"/>
         <ITEM DISPLAYNAME="Hardening_Rule" KEY="Hardening_Rule">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="Isotropic Hardening"/>
          <COLUMN DATATYPE="DOUBLE" VALUE="0.150000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Initial yield point" KEY="Initial_yield_point">
          <COLUMN DATATYPE="DOUBLE" VALUE="208000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Yield Criterion" KEY="Yield_Criterion">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="VMISES"/>
         </ITEM>
         <ITEM DISPLAYNAME="Hardening Parameter" KEY="Hardening_Param">
          <COLUMN DATATYPE="DOUBLE" VALUE="1"/>
         </ITEM>
        </Plastic>
        <Visco_Plastic>
         <ITEM DISPLAYNAME="Creep_Temperature_Exponent" KEY="Creep_Temperature_Exponent"/>
         <ITEM DISPLAYNAME="Creep_Stress_Exponent" KEY="Creep_Stress_Exponent"/>
         <ITEM DISPLAYNAME="Creep_Strain_Exponent" KEY="Creep_Strain_Exponent"/>
         <ITEM DISPLAYNAME="Creep_Time_Exponent" KEY="Creep_Time_Exponent"/>
        </Visco_Plastic>
       </Mechanical_Properties>
       <Thermal_Properties>
        <ITEM DISPLAYNAME="Thermal_conductivity" KEY="Thermal_conductivity">
         <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM DISPLAYNAME="Heat_capacity" KEY="Heat_capacity">
         <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM DISPLAYNAME="Latent Heat Effect" KEY="Latent_Heat_Effect">
         <COLUMN INDEX="0" DATATYPE="INDEX" LIST="None"/>
        </ITEM>
        <ITEM DISPLAYNAME="Free_Convection" KEY="Free_Convection"/>
        <ITEM DISPLAYNAME="Dynamic_Viscosity" KEY="Dynamic_Viscosity"/>
        <Radiation>
         <ITEM DISPLAYNAME="Radiation Effect" KEY="Radiation_Effect">
          <COLUMN DATATYPE="BOOL" CHECK="false"/>
         </ITEM>
        </Radiation>
        <ITEM DISPLAYNAME="Heat_Generation" KEY="Heat_Generation"/>
        <ITEM DISPLAYNAME="Reference_Enthalpy" KEY="Reference_Enthalpy"/>
        <ITEM DISPLAYNAME="TCH" KEY="TCH"/>
        <ITEM DISPLAYNAME="TDELTA" KEY="TDELTA"/>
        <ITEM DISPLAYNAME="QLAT" KEY="QLAT"/>
       </Thermal_Properties>
       <Electrical_Properties>
        <ITEM DISPLAYNAME="Electrical resistivity at reference temperature" KEY="Electrical resistance at reference temperature">
         <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
        </ITEM>
        <ITEM DISPLAYNAME="Temperature coefficient of resistance" KEY="Temperature coefficient of resistance">
         <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
        </ITEM>
       </Electrical_Properties>
       <Magnetic_Properties>
        <Permeability>
         <ITEM DISPLAYNAME="Type" KEY="Magnet_Type">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="None"/>
         </ITEM>
        </Permeability>
       </Magnetic_Properties>
       <Fatigue_Properties>
        <Static_parameters>
         <ITEM DISPLAYNAME="Yield_Strength" KEY="Yield_Strength">
          <COLUMN DATATYPE="DOUBLE" VALUE="235"/>
         </ITEM>
         <ITEM DISPLAYNAME="Ultimate_Tensile_Strength" KEY="Ultimate_Tensile_Strength">
          <COLUMN DATATYPE="DOUBLE" VALUE="380"/>
         </ITEM>
         <ITEM DISPLAYNAME="Units" KEY="Units">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="MPa"/>
         </ITEM>
        </Static_parameters>
        <Stress_Life_parameters>
         <ITEM DISPLAYNAME="Fatigue_strength_coefficient" KEY="Fatigue_strength_coefficient_stress">
          <COLUMN DATATYPE="DOUBLE" VALUE="1619.94"/>
         </ITEM>
         <ITEM DISPLAYNAME="First_Fatigue_strength_Exponent" KEY="First_Fatigue_strength_Exponent">
          <COLUMN DATATYPE="DOUBLE" VALUE="-0.125"/>
         </ITEM>
         <ITEM DISPLAYNAME="Endurance_Cycle_Limit_or_Transition_Point" KEY="Endurance_Cycle_Limit_or_Transition_Point">
          <COLUMN DATATYPE="DOUBLE" VALUE="1000000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Second_Fatigue_strength_Exponent" KEY="Second_Fatigue_strength_Exponent">
          <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatigue_Limit" KEY="Fatigue_Limit"/>
         <ITEM DISPLAYNAME="Standard_Error_of_Log" KEY="Standard_Error_of_Log">
          <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
         <ITEM DISPLAYNAME="Findley_Constant" KEY="Findley_Constant">
          <COLUMN DATATYPE="DOUBLE" VALUE="0.3"/>
         </ITEM>
         <ITEM DISPLAYNAME="Region_Layer" KEY="Region_Layer_stress">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="Worst"/>
         </ITEM>
         <ITEM DISPLAYNAME="Material_Surface_Finish" KEY="Material_Surface_Finish_Stress">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="None"/>
          <COLUMN DATATYPE="DOUBLE" VALUE="0.000000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Material_Surface_Treatment" KEY="Material_Surface_Treatment_Stress">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="None"/>
          <COLUMN DATATYPE="DOUBLE" VALUE="0.000000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatigue_Strength_Reduction_Factor" KEY="Fatigue_Strength_Reduction_Factor_Stress">
          <COLUMN DATATYPE="DOUBLE" VALUE="1"/>
         </ITEM>
        </Stress_Life_parameters>
        <Strain_Life_parameters>
         <ITEM DISPLAYNAME="Fatigue_strength_coefficient" KEY="Fatigue_strength_coefficient_strain">
          <COLUMN DATATYPE="DOUBLE" VALUE="570"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatigue_strength_exponent" KEY="Fatigue_strength_exponent">
          <COLUMN DATATYPE="DOUBLE" VALUE="-0.087"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatigue_ductility_exponent" KEY="Fatigue_ductility_exponent">
          <COLUMN DATATYPE="DOUBLE" VALUE="-0.58"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatigue_ductility_coefficient" KEY="Fatigue_ductility_coefficient">
          <COLUMN DATATYPE="DOUBLE" VALUE="0.59"/>
         </ITEM>
         <ITEM DISPLAYNAME="Cyclic_strain_hardening_exponent" KEY="Cyclic_strain_hardening_exponent">
          <COLUMN DATATYPE="DOUBLE" VALUE="0.15"/>
         </ITEM>
         <ITEM DISPLAYNAME="Cyclic_strength_coefficient" KEY="Cyclic_strength_coefficient">
          <COLUMN DATATYPE="DOUBLE" VALUE="627"/>
         </ITEM>
         <ITEM DISPLAYNAME="Reversal_Limit_Of_Endurance" KEY="Reversal_Limit_Of_Endurance">
          <COLUMN DATATYPE="DOUBLE" VALUE="200000000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Standard_Error_of_Log_Elastic" KEY="Standard_Error_of_Log_Elastic">
          <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
         <ITEM DISPLAYNAME="Standard_Error_of_Log_Plastic" KEY="Standard_Error_of_Log_Plastic">
          <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
         <ITEM DISPLAYNAME="Shear_Fatigue_Strength_coefficient" KEY="Shear_Fatigue_Strength_coefficient"/>
         <ITEM DISPLAYNAME="Shear_Fatigue_Ductility_coefficient" KEY="Shear_Fatigue_Ductility_coefficient"/>
         <ITEM DISPLAYNAME="Shear_Fatigue_Strength_exponent" KEY="Shear_Fatigue_Strength_exponent"/>
         <ITEM DISPLAYNAME="Shear_Fatigue_Ductility_exponent" KEY="Shear_Fatigue_Ductility_exponent"/>
         <ITEM DISPLAYNAME="Strength_coefficient_factor" KEY="Strength_coefficient_factor">
          <COLUMN DATATYPE="DOUBLE" VALUE="1.2"/>
         </ITEM>
         <ITEM DISPLAYNAME="Exponent_coefficient_factor" KEY="Exponent_coefficient_factor">
          <COLUMN DATATYPE="DOUBLE" VALUE="1"/>
         </ITEM>
         <ITEM DISPLAYNAME="Maximum_Strain_value" KEY="Maximum_Strain_value">
          <COLUMN DATATYPE="DOUBLE" VALUE="1.002"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatemi_Socie_Constant" KEY="Fatemi_Socie_Constant">
          <COLUMN DATATYPE="DOUBLE" VALUE="0.3"/>
         </ITEM>
         <ITEM DISPLAYNAME="Brown_Miller_Constant" KEY="Brown_Miller_Constant">
          <COLUMN DATATYPE="DOUBLE" VALUE="1"/>
         </ITEM>
         <ITEM DISPLAYNAME="Region_Layer" KEY="Region_Layer_strain">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="Worst"/>
         </ITEM>
         <ITEM DISPLAYNAME="Material_Surface_Finish" KEY="Material_Surface_Finish_Strain">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="None"/>
          <COLUMN DATATYPE="DOUBLE" VALUE="0.000000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Material_Surface_Treatment" KEY="Material_Surface_Treatment_Strain">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="None"/>
          <COLUMN DATATYPE="DOUBLE" VALUE="0.000000"/>
         </ITEM>
         <ITEM DISPLAYNAME="Fatigue_Strength_Reduction_Factor" KEY="Fatigue_Strength_Reduction_Factor_Strain">
          <COLUMN DATATYPE="DOUBLE" VALUE="1"/>
         </ITEM>
        </Strain_Life_parameters>
        <Factor_of_Safety>
         <ITEM DISPLAYNAME="Torsion_fatigue_limit" KEY="Torsion_fatigue_limit">
          <COLUMN DATATYPE="DOUBLE" VALUE="220"/>
          <COLUMN DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM DISPLAYNAME="Hydrostatic_stress_sensitivity" KEY="Hydrostatic_stress_sensitivity">
          <COLUMN DATATYPE="DOUBLE" VALUE="0.745"/>
         </ITEM>
         <ITEM DISPLAYNAME="Safe_zone_angle" KEY="Safe_zone_angle">
          <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
         <ITEM DISPLAYNAME="Shear_Threshold_Safezone" KEY="Shear_Threshold_Safezone">
          <COLUMN DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
         <ITEM DISPLAYNAME="Region_Layer" KEY="Region_Layer">
          <COLUMN INDEX="0" DATATYPE="INDEX" LIST="Worst"/>
         </ITEM>
        </Factor_of_Safety>
       </Fatigue_Properties>
      </TableData>
     </Material>''';
    simlab.execute(Material);

    Radius = float(Radius)
    Pi = 3.14159
    Area = Pi*Radius**2
    I = (Pi*Radius**4)/16
    Torsional = (Pi*Radius**4)/8

    if PropType == 'BAR':
        AnalysisProperty=''' <Property Auto="1" UUID="FAABD80A-7FA2-4d2a-961B-BFA06A361A4C">
          <tag Value="'''+PropertyName+'''"/>
          <Name Value="'''+PropertyName+'''"/>
          <Dimension Value="Bar"/>
          <Type Value="Bar"/>
          <ID Value="'''+PropertyName+'''"/>
          <Material Value="'''+MaterialName+'''"/>
          <SupportEntities>
           <Entities>
            <Model>'''+ModelNameRBE+'''</Model>
            <Body>"'''+BarName+str(0)+'''",</Body>
           </Entities>
          </SupportEntities>
          <UseExistingPropertyCheck Value="0"/>
          <CoordSystem Value=""/>
          <TableData>
           <Sys_Coord_Id Value="0" Type="4"/>
           <Area Value="'''+str(Area)+'''" Type="4"/>
           <I1 Value="'''+str(I)+'''" Type="4"/>
           <I2 Value="'''+str(I)+'''" Type="4"/>
           <Torsional Value="'''+str(Torsional)+'''" Type="4"/>
           <NSM Value="0" Type="4"/>
           <C1 Value="0" Type="4"/>
           <C2 Value="0" Type="4"/>
           <D1 Value="0" Type="4"/>
           <D2 Value="0" Type="4"/>
           <E1 Value="0" Type="4"/>
           <E2 Value="0" Type="4"/>
           <F1 Value="0" Type="4"/>
           <F2 Value="0" Type="4"/>
           <K1 Value="0.9" Type="4"/>
           <K2 Value="0.9" Type="4"/>
           <I12 Value="0" Type="4"/>
           <PA Value="0" Type="1"/>
           <PB Value="0" Type="1"/>
           <SectionType Value="O1Section" Type="5"/>
           <SectionParam Value="'''+str(Radius)+'''" Type="5"/>
           <Ansys_Section_Offset Value="0" Type="3"/>
           <WriteMaterial Value="1" Type="2"/>
           <Abaqus_Element_Type Value="0" Type="3"/>
           <Nastran_Bar_Type Value="0" Type="3"/>
           <Ansys_Element_Type Value="0" Type="3"/>
          </TableData>
          <Composite/>
          <Section Value="CIRCLE2">
           <R Value="'''+str(Radius)+'''"/>
          </Section>
         </Property>''';
        simlab.execute(AnalysisProperty);
    if PropType == 'BEAM':
        AnalysisProperty=''' <Property UUID="b05457c8-4e30-49ee-bddb-a2a20f04a3df">
          <tag Value="'''+PropertyName+'''"/>
          <Name Value="'''+PropertyName+'''"/>
          <ID Value="'''+PropertyName+'''"/>
          <Dimension Value="Bar" Index="2"/>
          <Type Value="Beam" Index="1"/>
          <Behavior Value="Default" Index="0"/>
          <Material Value="'''+MaterialName+'''" Index="0"/>
          <SupportEntities>
           <Entities>
            <Model>'''+ModelNameRBE+'''</Model>
            <Body>"'''+BarName+str(0)+'''",</Body>
           </Entities>
          </SupportEntities>
          <CoordSystem Value="" Index="-1"/>
          <TableData>
           <ITEM DISPLAYNAME="Sys Coord Id" KEY="Sys_Coord_Id">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Area" KEY="Area">
            <COLUMN DATATYPE="DOUBLE" UNIT="area" TYPE="EDITBOX" VALUE="'''+str(Area)+'''"/>
           </ITEM>
           <ITEM DISPLAYNAME="I1" KEY="I1">
            <COLUMN DATATYPE="DOUBLE" UNIT="inertia" TYPE="EDITBOX" VALUE="'''+str(I)+'''"/>
           </ITEM>
           <ITEM DISPLAYNAME="I2" KEY="I2">
            <COLUMN DATATYPE="DOUBLE" UNIT="inertia" TYPE="EDITBOX" VALUE="'''+str(I)+'''"/>
           </ITEM>
           <ITEM DISPLAYNAME="Torsional" KEY="Torsional">
            <COLUMN DATATYPE="DOUBLE" UNIT="inertia" TYPE="EDITBOX" VALUE="'''+str(Torsional)+'''"/>
           </ITEM>
           <ITEM DISPLAYNAME="NSM" KEY="NSM">
            <COLUMN DATATYPE="DOUBLE" UNIT="lineic mass" TYPE="EDITBOX" VALUE="0 kg/mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="C1" KEY="C1">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="C2" KEY="C2">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="D1" KEY="D1">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="D2" KEY="D2">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="E1" KEY="E1">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="E2" KEY="E2">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="F1" KEY="F1">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="F2" KEY="F2">
            <COLUMN DATATYPE="DOUBLE" UNIT="length" TYPE="EDITBOX" VALUE="0 mm"/>
           </ITEM>
           <ITEM DISPLAYNAME="K1" KEY="K1">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.9"/>
           </ITEM>
           <ITEM DISPLAYNAME="K2" KEY="K2">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.9"/>
           </ITEM>
           <ITEM DISPLAYNAME="I12" KEY="I12">
            <COLUMN DATATYPE="DOUBLE" UNIT="inertia" TYPE="EDITBOX" VALUE="0 mm4"/>
           </ITEM>
           <ITEM DISPLAYNAME="PA" KEY="PA">
            <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="PB" KEY="PB">
            <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Section Type" KEY="SectionType">
            <COLUMN DATATYPE="STRING" TYPE="EDITBOX" VALUE="O1Section"/>
           </ITEM>
           <ITEM DISPLAYNAME="Section Param" KEY="SectionParam">
            <COLUMN DATATYPE="STRING" TYPE="EDITBOX" VALUE="'''+str(Radius)+'''"/>
           </ITEM>
           <ITEM DISPLAYNAME="Ansys Section Offset" KEY="Ansys_Section_Offset">
            <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" LIST="Centroid" VALUE="Centroid" INDEX="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Write Material" KEY="WriteMaterial">
            <COLUMN DATATYPE="BOOL" CHECK="true" TYPE="CHECKBOX" VALUE=""/>
           </ITEM>
           <ITEM DISPLAYNAME="Abaqus Element Type" KEY="Abaqus_Element_Type">
            <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" LIST="Default" VALUE="Default" INDEX="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Nastran Beam Type" KEY="Nastran_Beam_Type">
            <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" LIST="PBEAM" VALUE="PBEAM" INDEX="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Ansys Element Type" KEY="Ansys_Element_Type">
            <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" LIST="BEAM188_Linear" VALUE="BEAM188_Linear" INDEX="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Small Strain Option" KEY="Small_Strain_Option">
            <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" LIST="0" VALUE="0" INDEX="0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Membrance Damping" KEY="Membrance_Damping">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Flexural Damping" KEY="Flexural_Damping">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Moment of Inertia Bending Y" KEY="Moment_of_Inertia_Bending_Y">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Moment of Inertia Bending Z" KEY="Moment_of_Inertia_Bending_Z">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Moment of Inertia Torsion" KEY="Moment_of_Inertia_Torsion">
            <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0.0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Rotation DOF" KEY="Rotation_DOF">
            <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0.0"/>
           </ITEM>
           <ITEM DISPLAYNAME="Beam Formulation" KEY="Beam_Formulation">
            <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" LIST="Include Shear" VALUE="Include Shear" INDEX="0"/>
           </ITEM>
          </TableData>
          <Section Value="CIRCLE2">
           <R Value="'''+str(Radius)+'''"/>
          </Section>
         </Property>''';
        simlab.execute(AnalysisProperty);
    
DeleteGroupControl=''' <DeleteGroupControl UUID="2a3b5834-9708-4b03-871c-6d05623667bd" CheckBox="ON">
  <tag Value="-1"/>
  <Name Value="CenterNodes_top,CenterNodes_bottom,"/>
  <Output/>
 </DeleteGroupControl>''';
simlab.execute(DeleteGroupControl);
