#***************************************************************
#SimLab Version 2019.1 Beta
#Created at Wed Nov 14 09:10:24 2018
#***************************************************************
from hwx import simlab


SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
  <ParamInfo Type="real" Name="MeshSize" Value="1"/>
 </Parameters>''';
simlab.execute(SimLabParameters);

SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
  <ParamInfo Type="real" Name="AspectRatio" Value="10"/>
 </Parameters>''';
simlab.execute(SimLabParameters);

SimLabParameters=''' <Parameters UUID="67a54923-dbd3-4d54-931b-2405601ba45f">
  <ParamInfo Type="real" Name="Pressure" Value="100"/>
 </Parameters>''';
simlab.execute(SimLabParameters);

ImportProE=''' <ImportProE CheckBox="ON" UUID="ccfb0134-4019-48a1-8387-e95c1b04f1a0" gda="">
  <tag Value="1"/>
  <FileName Value="./fan_model.prt.2"/>
  <SolidBodyType Value="1"/>
  <QuiltBodyType Value="0"/>
  <CurveBodyType Value="0"/>
  <ExactGeom Value="1"/>
  <Facets Value="0"/>
  <CoOrdinates Value="0"/>
  <DatumPoints Value="0"/>
  <DesignParameters Value="1"/>
  <SimRep Value="0"/>
  <Regenerate Value="0"/>
  <ImportOption Value="0"/>
  <RegenModelId Value="0"/>
  <ImportAssemblyStructure Value="0"/>
  <InstanceName Value=""/>
  <SaveGeometry Value="0"/>
  <Path Value=""/>
  <Output/>
 </ImportProE>''';
simlab.execute(ImportProE);

SurfaceMesh=''' <SurfaceMesh UUID="08df0ff6-f369-4003-956c-82781326c876">
  <tag Value="-1"/>
  <SurfaceMeshType Value="Tri"/>
  <SupportEntities>
   <Entities>
    <Model>$Geometry</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <Tri>
   <ElementType Value="Tri3"/>
   <AverageElementSize Value="$MeshSize" Checked="1"/>
   <MaximumElementSize Value="1.414" Checked="0"/>
   <MinimumElementSize Value="$MeshSize/AspectRatio"/>
   <GradeFactor Value="1.5"/>
   <MaximumAnglePerElement Value="45"/>
   <CurvatureMinimumElementSize Value="0.5"/>
   <AspectRatio Value="$AspectRatio"/>
   <AdvancedOptions>
    <IdentifyFeaturesAndMesh Checked="1"/>
    <ImprintMeshing Checked="0"/>
    <BetterGeometryApproximation Checked="0"/>
    <CoarseMesh Checked="0"/>
    <CoarseMesh_UseExistingNodes Checked="0"/>
    <CreateMeshInNewModel Checked="1"/>
    <UserDefinedModelName Value=""/>
    <Tri6WithStraightEdges Checked="0"/>
    <ImproveSkewAngle Value="0"/>
    <MappedMesh Value="0"/>
    <MeshPattern Value="0"/>
   </AdvancedOptions>
  </Tri>
 </SurfaceMesh>''';
simlab.execute(SurfaceMesh);

VolumeMesh=''' <VolumeMesher UUID="83822e68-12bb-43b9-b2ac-77e0b9ea5149">
  <tag Value="-1"/>
  <Name Value="VolumeMesher1"/>
  <SupportEntities>
   <Entities>
    <Model>fan_model1_SM.gda</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <MeshType Value="Tet10"/>
  <AverageElemSize Value="$MeshSize"/>
  <MaxElemSize Value="0" Checked="0"/>
  <InternalGrading Value="2"/>
  <MinQuality Value="0.1"/>
  <LinearQuality Value="0"/>
  <MaxQuality Value="1"/>
  <QuadMinQuality Value="0.001"/>
  <QuadQuality Value="0"/>
  <QuadMaxQuality Value="1"/>
  <CadBody Value="0"/>
  <NumberofLayers Value="1" Checked="1"/>
  <LayerThickness Value="0" Checked="0"/>
  <AdvancedOptions>
   <MeshDensity Value="0"/>
   <CreateVol Value="0"/>
   <OutputModelName Value=""/>
   <Assembly Value="0"/>
   <PreserveFaceMesh Value="0"/>
   <MeshAsSingleBody Value="0"/>
   <Retain2DSurfaceBodies Value="0"/>
   <PreserveSurfaceSkew Value="55" Checked="0"/>
   <MixedMesh Value="0"/>
  </AdvancedOptions>
 </VolumeMesher>''';
simlab.execute(VolumeMesh);

TransferGroup=''' <TransferGroup CheckBox="ON" UUID="6ee43b88-c248-427d-8107-c4144624bbab">
  <tag Value="-1"/>
  <Method Value="PersistentID"/>
  <SourceBodies>
   <Entities>
    <Model>$Geometry</Model>
    <Body></Body>
   </Entities>
  </SourceBodies>
  <TargetBodies>
   <Entities>
    <Model>fan_model1_SM.gda</Model>
    <Body></Body>
   </Entities>
  </TargetBodies>
  <RemoveEntitiesFromGroup Value="0"/>
  <Tolerance Value="0.001"/>
 </TransferGroup>''';
simlab.execute(TransferGroup);

Pressure=''' <Pressure UUID="a901aa45-1913-42f4-892f-a9cb2f0bbf4b">
  <tag Value="-1"/>
  <Name Value="Pressure_1"/>
  <PressureEntities>
   <Group>"PRESSURE_LOAD_VM",</Group>
  </PressureEntities>
  <Magnitude Value="$Pressure"/>
  <FieldData Value="None" Index="0"/>
  <Option Value="1"/>
  <TotalForce Value="0"/>
 </Pressure>''';
simlab.execute(Pressure);

FixedConstraint=''' <Fixed isObject="2" UUID="f5ecfc0a-a238-477c-928c-e81c22353a69">
  <tag Value="-1"/>
  <Name Value="Face_Constraint_2"/>
  <FixedEntities>
   <Group>"CONSTRAINTS_VM",</Group>
  </FixedEntities>
  <CoordinateAxisID Value="Global" Index="0"/>
  <UseParameter Value="0"/>
  <Parameter Value="111000"/>
  <Tx Value="1"/>
  <Ty Value="1"/>
  <Tz Value="1"/>
  <Rx Value="0"/>
  <Ry Value="0"/>
  <Rz Value="0"/>
 </Fixed>''';
simlab.execute(FixedConstraint);

Material=''' <Material UUID="31d13165-03f9-4e35-b548-a88621b8562a">
  <tag Value="-1"/>
  <Name Value="Steel"/>
  <Category Value="Metal"/>
  <Type Value="Isotropic"/>
  <Model Value="Elastic"/>
  <MaterialId Value="1"/>
  <TableData>
   <Youngs_modulus table="" Type="4" Value="208000"/>
   <Shear_modulus table="" Type="4" Value=""/>
   <Poissons_ratio table="" Type="4" Value="0.30"/>
   <Density table="" Type="4" Value="7.8e-9"/>
   <Thermal_Expansion table="" Type="4" Value="0.0"/>
   <Reference_Temperature table="" Type="4" Value="20"/>
   <Damping_coefficient table="" Type="4" Value=""/>
   <Stress_Tension table="" Type="4" Value="0.00"/>
   <Stress_Compression table="" Type="4" Value="0.00"/>
   <Stress_Shear table="" Type="4" Value="0.00"/>
   <Mat_Cord_Sys table="" Type="4" Value="0"/>
   <Thermal_conductivity table="" Type="4" Value="4.98100E-02"/>
   <Heat_capacity table="" Type="4" Value="0.5"/>
   <Free_Convection table="" Type="4" Value="0.00"/>
   <Dynamic_Viscosity table="" Type="4" Value="0.00"/>
   <Heat_Generation table="" Type="4" Value="1.00"/>
   <Reference_Enthalpy table="" Type="4" Value="0.00"/>
   <TCH table="" Type="4" Value="0.00"/>
   <TDELTA table="" Type="4" Value="0.00"/>
   <QLAT table="" Type="4" Value="0.00"/>
  </TableData>
 </Material>''';
simlab.execute(Material);

AnalysisProperty=''' <Property UUID="FAABD80A-7FA2-4d2a-961B-BFA06A361A4C">
  <tag Value="-1"/>
  <Name Value="fan_Steel"/>
  <Dimension Value="Solid"/>
  <Type Value="Isotropic"/>
  <ID Value="1"/>
  <Material Value="Steel"/>
  <SupportEntities>
   <Entities>
    <Model>fan_model1_SM.gda</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <UseExistingPropertyCheck Value="0"/>
  <CoordSystem Value=""/>
  <TableData>
   <WriteMaterial Type="2" Value="1"/>
   <Abaqus_Element_Type Type="3" Value="0"/>
   <OptiStruct_Explicit_Element_Type Type="3" Value="0"/>
   <Ansys_Element_Type Type="3" Value="0"/>
   <Fatigue_Material Type="3" Value="None"/>
  </TableData>
  <Composite/>
 </Property>''';
simlab.execute(AnalysisProperty);

SolverSettings=''' <SolutionParamOption UUID="0768c58f-4f3f-4e62-9efd-1ab017375c43" pixmap="solution">
  <tag Value="-1"/>
  <Name Value=""/>
  <SolverName Value="OPTISTRUCT"/>
  <FileName Value=""/>
  <WriteMode Value=""/>
  <Renumber Value=""/>
  <RunSolver Value=""/>
  <RemoveOrphanNodes Value=""/>
  <Version Value="14"/>
  <SolverSetingType Value=""/>
  <Solution Value=""/>
  <AnalysisType Value="LINEAR" Index="0">
   <Version Value="14"/>
   <SolverName Value="OPTISTRUCT"/>
   <AnalysisType Value="LINEAR">
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Optimization Algorithm" VALUE="0"/>
    <ITEM STATUS="OFF" DATATYPE="DOUBLE" TYPE="CHECKEDITBOX" NAME="Max number of design iterations" VALUE="30"/>
    <ITEM STATUS="OFF" DATATYPE="DOUBLE" TYPE="CHECKEDITBOX" NAME="Objective tolerance" VALUE="0.005"/>
    <ITEM STATUS="OFF" DATATYPE="DOUBLE" TYPE="CHECKEDITBOX" NAME="Re-mesh on iteration" VALUE="3"/>
    <ITEM STATUS="OFF" DATATYPE="DOUBLE" TYPE="CHECKEDITBOX" NAME="Max number of Re-mesh trials" VALUE="25"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="AUTOSPC" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="CHECKEL" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="CONTFEL" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="FASTCONT" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="GAPPRM CKGPDIR" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="GAPPRM GAPCMPL" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="HASHASSM" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="I64SLV" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="INREL" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="OGEOM" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="PRETPRM INILOAD" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="PRETPRM PRTSW" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="PRINFACC" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="PRGPST" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="PRTMGG" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="REFPNT" VALUE="0"/>
    <ITEM STATUS="OFF" DATATYPE="DOUBLE" TYPE="CHECKEDITBOX" NAME="SHL2MEM" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="ASSIGN-File Type" VALUE="0"/>
    <ITEM DATATYPE="STRING" TYPE="EDITBOX" NAME="ASSIGN-File Name/Subcase Id/Matrix Name" VALUE=""/>
    <ITEM DATATYPE="STRING" TYPE="EDITBOX" NAME="ASSIGN-File Name" VALUE=""/>
    <ITEM DATATYPE="USER" TYPE="EDITBOXWITHBROWSER" NAME="Input Output Section File" VALUE=""/>
    <ITEM DATATYPE="USER" TYPE="EDITBOXWITHBROWSER" NAME="Bulk Data Section File" VALUE=""/>
   </AnalysisType>
  </AnalysisType>
 </SolutionParamOption>''';
simlab.execute(SolverSettings);

OutputRequestOption=''' <OutputRequestOption UUID="56b65ec2-6934-4a69-addf-732def4d4d2b" pixmap="solution">
  <tag Value="-1"/>
  <Name Value=""/>
  <SolverName Value="OPTISTRUCT"/>
  <FileName Value=""/>
  <WriteMode Value=""/>
  <Renumber Value=""/>
  <RunSolver Value=""/>
  <RemoveOrphanNodes Value=""/>
  <Version Value="14"/>
  <SolverSetingType Value=""/>
  <Solution Value=""/>
  <AnalysisType Value="LINEAR" Index="0">
   <Version Value="14"/>
   <SolverName Value="OPTISTRUCT"/>
   <AnalysisType Value="LINEAR">
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Output File Format" VALUE="1"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Output File Frequency" VALUE="3"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Output Control to Unix/DOS(Screen)" VALUE="2"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Displacement" VALUE="1"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Rotation" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Temperature" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Applied Load" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Constraint Force" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Multi Point Constraint Force" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Force Balance" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Velocity" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Acceleration" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Element Force" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Stress" VALUE="1"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Stress at Surface" VALUE="0"/>
    <ITEM DATATYPE="INT" TYPE="COMBOBOX" NAME="Strain" VALUE="0"/>
    <ITEM DATATYPE="BOOL" TYPE="CHECKBOX" NAME="Strain Energy" VALUE="0"/>
    <ITEM DATATYPE="USER" TYPE="COMBOBOX" NAME="Bore Distortion" VALUE="None"/>
   </AnalysisType>
  </AnalysisType>
 </OutputRequestOption>''';
simlab.execute(OutputRequestOption);

ExportandSolve=''' <ExportStaticSolverInput UUID="f009bc99-991f-43b7-8c87-cc606ef9c443" pixmap="solution">
  <tag Value="-1"/>
  <Name Value="ExportStaticSolverInput1"/>
  <SolverName Value="OPTISTRUCT" Version="0"/>
  <FileName Value="./fan_Solution.fem"/>
  <Solution Value=""/>
  <WriteMode ValueText="Default" Value="0"/>
  <LoadCase Value="Default"/>
  <Renumber Value="0"/>
  <RunSolver Value="1"/>
  <DataCheck Value="0"/>
  <RemoveOrphanNodes Value="1"/>
  <Version Value="14"/>
  <ExportOptionsVersion Value="1"/>
  <RemoteSolve Value="0"/>
  <SupportEntities>
   <Entities>
    <Model>fan_model1_SM.gda</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <AnalysisType Value="LINEAR" Index="0">
   <CATEGORY_Export_Options key="CATEGORY_Export_Options" ValueText="" decoration="0" name="Export Options"/>
   <Title key="Title" type="string" ValueText="Linear Static Step" decoration="0" name="Title" Value="Linear Static Step"/>
   <Format key="Format" type="int" ValueText="Small Field" decoration="0" name="Format" Value="0"/>
   <Numbering key="Numbering" type="int" ValueText="Ascending Order" decoration="0" name="Numbering" Value="0"/>
   <Write_Linear_Elements key="Write_Linear_Elements" type="check" ValueText="False" decoration="0" name="Write Linear Elements" Value="0"/>
   <Spring_Element_Card_Format key="Spring_Element_Card_Format" type="int" ValueText="CELAS1" decoration="0" name="Spring Element Card Format" Value="0"/>
   <Write_Contact_Slave_Surface_as_SURF key="Write_Contact_Slave_Surface_as_SURF" type="check" ValueText="False" decoration="0" name="Write Contact Slave Surface as SURF" Value="0"/>
   <Write_Enforced_Displacements_as_SPCD key="Write_Enforced_Displacements_as_SPCD" type="check" ValueText="True" decoration="0" name="Write Enforced Displacements as SPCD" Value="1"/>
   <Global_initial_temperature checkval="0" key="Global_initial_temperature" type="double" ValueText="20" decoration="1" name="Global initial temperature" Value="20"/>
   <CATEGORY_System_Settings key="CATEGORY_System_Settings" ValueText="" decoration="0" name="System Settings"/>
   <Initial_memory_allocation__MB_ checkval="0" key="Initial_memory_allocation__MB_" type="double" ValueText="100" decoration="1" name="Initial memory allocation (MB)" Value="100"/>
   <PBUSHFORM key="PBUSHFORM" type="int" ValueText="Solver Default" decoration="0" name="PBUSHFORM" Value="0"/>
   <CATEGORY_Material key="CATEGORY_Material" ValueText="" decoration="0" name="Material"/>
   <Write_Material key="Write_Material" type="check" ValueText="True" decoration="0" name="Write Material" Value="1"/>
   <External_File key="External_File" type="string" ValueText="" decoration="32" name="External File" Value=""/>
   <CATEGORY_Spawn_Solver_Options key="CATEGORY_Spawn_Solver_Options" ValueText="" decoration="0" name="Spawn Solver Options"/>
   <Number_of_Processors key="Number_of_Processors" type="int" ValueText="0" decoration="0" name="Number of Processors" Value="0"/>
   <RAM_Allocation key="RAM_Allocation" type="int" ValueText="0" decoration="0" name="RAM Allocation" Value="0"/>
   <Additional_Arguments key="Additional_Arguments" type="string" ValueText="" decoration="0" name="Additional_Arguments" Value=""/>
  </AnalysisType>
 </ExportStaticSolverInput>''';
simlab.execute(ExportandSolve);

CreateResponse=''' <CreateResponse UUID="43b423e8-14ea-4106-9fdd-00d5f528b3ea">
  <tag Value="-1"/>
  <Name Value="Max_Displacement"/>
  <SupportEntities>
   <Entities>
    <Model>fan_model1_SM.gda</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <Loadcase Value="Subcase 1"/>
  <Component Value="Displacement"/>
  <Axis Value="Resultant"/>
  <ResultsType Value="Max"/>
  <RootName ModeIndex="" Frequency="" ModelIds="" Value="" CurrentItemName=""/>
 </CreateResponse>''';
simlab.execute(CreateResponse);

CreateResponse=''' <CreateResponse UUID="43b423e8-14ea-4106-9fdd-00d5f528b3ea">
  <tag Value="-1"/>
  <Name Value="Max_Stress"/>
  <SupportEntities>
   <Entities>
    <Model>fan_model1_SM.gda</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <Loadcase Value="Subcase 1"/>
  <Component Value="Element Stresses (2D &amp; 3D)"/>
  <Axis Value="Von Mises"/>
  <ResultsType Value="Max"/>
  <RootName ModeIndex="" Frequency="" ModelIds="" Value="" CurrentItemName=""/>
 </CreateResponse>''';
simlab.execute(CreateResponse);

UpdateResponses=''' <UpdateResponses UUID="867bf814-69c7-43cb-8566-78bd2a3d4e5f"/>''';
simlab.execute(UpdateResponses);

ExportSlb=''' <ExportSlb UUID="a155cd6e-8ae6-4720-8ab4-1f50d4a34d1c">
  <tag Value="-1"/>
  <Name Value=""/>
  <Option Value="1"/>
  <FileName Value="./fan_Database.slb"/>
 </ExportSlb>''';
simlab.execute(ExportSlb);
