#***************************************************************
#SimLab Version 2022.1 Beta
#Created at Wed Jun 15 11:42:29 2022
#***************************************************************
#For debugging this python script,Please comment(#) out the line "from hwx import simlab" and uncomment the line "import simlab"
#import simlab
from hwx import simlab

UnitSystem=''' <UnitSystem UUID="3aca8564-4d38-4b0b-887c-6a542d4001c6">
  <SetCurrentDisplaySystem Name="MMKS (mm kg N C s)"/>
 </UnitSystem>''';
simlab.execute(UnitSystem);

#List to add the coordinate points of the cylinder's axis
TopAxisPts=[]
BottomAxisPts=[]


#Creating groups for the cylindrical faces of the bodies.
SelectFeatures=''' <SelectFeatures CheckBox="ON" UUID="CF82E8FB-9B3E-4c02-BA93-9466C1342C6E">
  <SupportEntities>
   <Entities>
    <Model>Input.gda</Model>
    <Body>"Cover",</Body>
   </Entities>
  </SupportEntities>
  <Arcs MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <ArcsAll Value="56"/>
  <Circles MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <CirclesAll Value="0"/>
  <Cones MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <ConeAll Value="0"/>
  <FullCone Value="0"/>
  <ClosedPartialCone Value="0"/>
  <OpenPartialCone Value="0"/>
  <TaperAngle Angle="0 deg" Value="0"/>
  <Dics MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <DicsAll Value="0"/>
  <HollowDics MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <HollowDicsAll Value="0"/>
  <Cylinders MinValue="4.4 mm" Value="1" MaxValue="4.5 mm"/>
  <CylindersAll Value="0"/>
  <FullCylinder Value="1"/>
  <ClosedPartialCylinder Value="0"/>
  <OpenPartialCylinder Value="0"/>
  <Fillets MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <FilletsOption Value="1"/>
  <PlanarFaces Value="0"/>
  <FourEdgedFaces Value="0"/>
  <ConnectedCoaxialFaces Value="0"/>
  <ThroughBoltHole MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <BlindBoltHole MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <BlindBoltHoleDepth MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <SlotEdges MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <SlotEdgesAll Value="0"/>
  <CreateGrp Name="Cyl_Top" Value="1"/>
  <ArcLengthBased Value=""/>
  <AngleBased Value=""/>
  <SharpEdges Option="" Angle="" Value=""/>
 </SelectFeatures>''';
simlab.execute(SelectFeatures);

SelectFeatures=''' <SelectFeatures CheckBox="ON" UUID="CF82E8FB-9B3E-4c02-BA93-9466C1342C6E">
  <SupportEntities>
   <Entities>
    <Model>Input.gda</Model>
    <Body>"Carrier",</Body>
   </Entities>
  </SupportEntities>
  <Arcs MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <ArcsAll Value="56"/>
  <Circles MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <CirclesAll Value="0"/>
  <Cones MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <ConeAll Value="0"/>
  <FullCone Value="0"/>
  <ClosedPartialCone Value="0"/>
  <OpenPartialCone Value="0"/>
  <TaperAngle Angle="0 deg" Value="0"/>
  <Dics MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <DicsAll Value="0"/>
  <HollowDics MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <HollowDicsAll Value="0"/>
  <Cylinders MinValue="3.2 mm" Value="1" MaxValue="3.4 mm"/>
  <CylindersAll Value="0"/>
  <FullCylinder Value="1"/>
  <ClosedPartialCylinder Value="0"/>
  <OpenPartialCylinder Value="0"/>
  <Fillets MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <FilletsOption Value="1"/>
  <PlanarFaces Value="0"/>
  <FourEdgedFaces Value="0"/>
  <ConnectedCoaxialFaces Value="0"/>
  <ThroughBoltHole MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <BlindBoltHole MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <BlindBoltHoleDepth MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <SlotEdges MinValue="0 mm" Value="0" MaxValue="0 mm"/>
  <SlotEdgesAll Value="0"/>
  <CreateGrp Name="Cyl_Bottom" Value="1"/>
  <ArcLengthBased Value=""/>
  <AngleBased Value=""/>
  <SharpEdges Option="" Angle="" Value=""/>
 </SelectFeatures>''';
simlab.execute(SelectFeatures);

#Creating groups for connected faces from the "Cyl_Top" and "Cyl_Bottom" face groups
TopGroupNames=simlab.createGroupsOfConnectedEntities("Cyl_Top")
BottomGroupNames=simlab.createGroupsOfConnectedEntities("Cyl_Bottom")

count=1

#Creating the list of coordinate points of the cylinder's axis
for i in range(0,len(TopGroupNames)):
    TAx1, TAx2, TRd = simlab.getCylindricalFaceAttributes(TopGroupNames[i])
    TopAxisPts.append(TAx1)
    BAx2, BAx2, BRd = simlab.getCylindricalFaceAttributes(BottomGroupNames[i])
    BottomAxisPts.append(BAx2)

for i in range(0,len(TopAxisPts)):
    for j in range(0,len(BottomAxisPts)):
	#Condition to check whether the cylinders are coaxial or not.
        if ((TopAxisPts[i][0] == BottomAxisPts[j][0]) and (TopAxisPts[i][1] == BottomAxisPts[j][1])) or ((TopAxisPts[i][0] == BottomAxisPts[j][0]) and (TopAxisPts[i][2] == BottomAxisPts[j][2])) or ((TopAxisPts[i][1] == BottomAxisPts[j][1]) and (TopAxisPts[i][2] == BottomAxisPts[j][2])):
            
            #If the conditon is satisfied, the respective cylindrical face IDs will be stored in TopIds and BottomIds respectively as below.
            TopIds = simlab.getEntityFromGroup(TopGroupNames[i])
            BottomIds=simlab.getEntityFromGroup(BottomGroupNames[j])
            Group=TopIds+BottomIds

	   #Creating groups for the identified cylindrical pairs	
            CreateGroup=''' <CreateGroup CheckBox="OFF" isObject="4" UUID="899db3a6-bd69-4a2d-b30f-756c2b2b1954">
              <tag Value="-1"/>
              <Name OldValue="" Value="'''+"CoaxialCylindricalPair"+str(count)+'''"/>
              <SupportEntities>
               <Entities>
                <Model>Input.gda</Model>
                <Face>'''+str(Group).strip('()')+''',</Face>
               </Entities>
              </SupportEntities>
              <Type Value="Face"/>
              <Color Value="255,0,255,"/>
              <Dup Value="0"/>
             </CreateGroup>''';
            simlab.execute(CreateGroup);

	    #Creating RBE for the cylindrical pair groups
            CreateRBE=''' <RBE CheckBox="ON" UUID="27FFA2F5-6388-4d38-A5FA-6DCC883C1094">
              <tag Value="-1"/>
              <Name Value="'''+"RBE"+str(count)+'''"/>
              <InputEntities>
               <Group>"'''+"CoaxialCylindricalPair"+str(count)+'''",</Group>
              </InputEntities>
              <Group Value=""/>
              <CenterSupportNodes ModelIds="" Value="" EntityTypes=""/>
              <CenterSupportEdges ModelIds="" Value="" EntityTypes=""/>
              <BodyAllNodes Value="1"/>
              <BodyFewNodes Value="0"/>
              <CenterNodeId Value=""/>
              <ConnectionType Value="0"/>
              <RadiusLimit Check="0" Value="0.0"/>
              <CenterNodeSupport Value="0"/>
              <IgnoreMidNodes Value="0"/>
              <CreateRBE_eachRegion Value="0"/>
              <Output/>
             </RBE>''';
            simlab.execute(CreateRBE);

            count=count+1


