#include <stdio.h>
#include <stdlib.h>
#include "acusim.h"
#include "udf.h"


/**********************************************************/
//add heat source to disc plate

/**********************************************************/
//add heat source to disc plate
UDF_PROTOTYPE(usrDiscHeatSource) ;

Void usrDiscHeatSource(      UdfHd           udfHd,
                  Real*           outVec,
                  Integer         nItems,
                  Integer         vecDim )
{
    Integer     i ;
    Real        time, timeClean;
    Real        r2Temp;
    Real*       crd ;
    Real        endTime;
    Real        qmax, qrealtime;

    endTime = 2.8;
    qmax   = 2.218825e6;

    time = udfGetTime( udfHd );

    timeClean = time;
    while (timeClean > 18.7){ timeClean -= 18.7; }
    if (timeClean <= endTime){

        qrealtime = qmax* (endTime - timeClean)/endTime;

        crd = udfGetEbcCrd( udfHd ) ;
        //In current case, Y-axis ----------------
        for ( i = 0 ; i < nItems ; i++ ) {

            r2Temp = pow(crd[0*nItems+i],2.0) + pow(crd[2*nItems+i],2.0);

            if ( (r2Temp> 0.0121)&& (r2Temp< 0.0196) ){
                outVec[i] = qrealtime;
                }
                else
                {
                    outVec[i] = 0.0;
                }
            }

    }
    else{
        for ( i = 0 ; i < nItems ; i++ ) {
            outVec[i] = 0.0;
        }
    }
}

