#***************************************************************
#SimLab Version 2019.1 Beta
#Created at Mon Oct 29 09:34:34 2018
#***************************************************************
from hwx import simlab
import os

fileNames = []
for dirpath,dirnames,filenames in os.walk("./Input/"):
    fileNames = filenames;

for fileName in fileNames:

    if len(fileName) == 0:
        continue;

    if fileName.endswith(".xml"):
     continue;
    
    simlab.newDocument();

    filePath = "./Input/" + fileName;
    filenamewithoutextension = os.path.splitext(fileName)[0];
    
    ImportParasolid=''' <ImportParasolid CheckBox="ON" Type="Parasolid" UUID="400d622c-e74a-4f87-bc0b-af51659b9b6d" gda="">
      <tag Value="1"/>
      <FileName widget="LineEdit" HelpStr="File name to be imported." Value="'''+filePath+'''"/>
      <Units HelpStr="Units to which this file is to be imported into" Value="MilliMeter"/>
      <SolidBodyType Value="1"/>
      <SheetBodyType Value="0"/>
      <WireBodyType Value="0"/>
      <ImportasFacets Value="0"/>
      <Imprint Value="0"/>
      <Groups Value="0"/>
      <Merge Value="0"/>
      <ImportAssemblyStructure Value="1"/>
      <SaveGeometryInDatabase Value="0"/>
      <FileCount value="0" Value="0"/>
      <Output widget="NULL"/>
      <ImportOption Value="1"/>
      <TransXmlFileName Value=""/>
      <TransOutFileName Value=""/>
     </ImportParasolid>''';
    simlab.execute(ImportParasolid);

    parameterFilePath = "./Input/" + filenamewithoutextension + "_Parameters.xml";

    ImportParameters=''' <ImportParameters UUID="1c7910a2-2c5a-4618-a496-02b4bce9fc3d">
      <FileName Value="'''+parameterFilePath+'''"/>
     </ImportParameters>''';
    simlab.execute(ImportParameters);

    meshSize = simlab.getDoubleParameter("$MeshSize");

    SurfaceMesh=''' <SurfaceMesh UUID="08df0ff6-f369-4003-956c-82781326c876">
      <tag Value="-1"/>
      <SurfaceMeshType Value="Tri"/>
      <SupportEntities>
       <Entities>
        <Model>$Geometry</Model>
        <Body></Body>
       </Entities>
      </SupportEntities>
      <Tri>
       <ElementType Value="Tri3"/>
       <AverageElementSize Value="'''+str(meshSize)+'''" Checked="1"/>
       <MaximumElementSize Value="7.07" Checked="0"/>
       <MinimumElementSize Value="0.5"/>
       <GradeFactor Value="1.5"/>
       <MaximumAnglePerElement Value="45"/>
       <CurvatureMinimumElementSize Value="2.5"/>
       <AspectRatio Value="10"/>
       <AdvancedOptions>
        <IdentifyFeaturesAndMesh Checked="0"/>
        <ImprintMeshing Checked="0"/>
        <BetterGeometryApproximation Checked="0"/>
        <CoarseMesh Checked="0"/>
        <CoarseMesh_UseExistingNodes Checked="0"/>
        <CreateMeshInNewModel Checked="1"/>
        <UserDefinedModelName Value=""/>
        <Tri6WithStraightEdges Checked="0"/>
        <ImproveSkewAngle Value="0"/>
        <MappedMesh Value="1"/>
        <MeshPattern Value="0"/>
       </AdvancedOptions>
      </Tri>
     </SurfaceMesh>''';
    simlab.execute(SurfaceMesh);

    ModelName = simlab.getModelName("FEM");
    QualityCheck=''' <QCheck UUID="412da11b-2793-4c07-a058-e49f209f007d">
      <ElementType Value="Tri"/>
      <Option Value="Compute"/>
      <Quality Condition="G Than Or Eq" Name="Aspect Ratio" DefaultValue="10"/>
      <Quality Condition="L Than" Name="Edge Length" DefaultValue="0.5"/>
      <Quality SecDefaultValue="160" Condition="L Than" Name="Interior Angle" DefaultValue="8"/>
      <Quality Condition="L Than" Name="Stretch" DefaultValue="0.1"/>
      <Quality Condition="G Than" Name="Skew" DefaultValue="75"/>
      <Quality Condition="L Than" Name="Element Face Angle" DefaultValue="45"/>
      <Quality Condition="L Than" Name="Area" DefaultValue="0"/>
      <Quality Condition="G Than" Name="Mid-Node Offset : Ratio" DefaultValue="0.5"/>
      <Quality Condition="G Than" Name="Mid-Node Offset : Distance" DefaultValue="0.5"/>
      <Quality Condition="L Than" Name="Jacobian Ratio" DefaultValue="0.1"/>
      <Quality Condition="L Than" Name="Area Skew" DefaultValue="0.01"/>
      <Quality Condition="G Than" Name="Area Skew : Fluent" DefaultValue="0.95"/>
      <Quality Condition="L Than" Name="Height" DefaultValue="0.5"/>
      <SupportEntities>
       <Entities>
        <Model>'''+ModelName+'''</Model>
        <Body></Body>
       </Entities>
      </SupportEntities>
     </QCheck>''';
    simlab.execute(QualityCheck);

    WriteReportPath = "./Output/" + filenamewithoutextension + "_Quality_Report.html";
    QualityCheck=''' <QCheck UUID="412da11b-2793-4c07-a058-e49f209f007d">
      <ElementType Value="Tri"/>
      <Option Value="Write Report"/>
      <FileName Value="'''+WriteReportPath+'''"/>
      <AppendToFile Value="false"/>
      <WriteColumns TotalCount="0" FailurePerc="1" FailureCount="0"/>
     </QCheck>''';
    simlab.execute(QualityCheck);

    OutputPath = "./Output/" + filenamewithoutextension + "_output.slb";
    ExportSlb=''' <ExportSlb UUID="a155cd6e-8ae6-4720-8ab4-1f50d4a34d1c">
      <tag Value="-1"/>
      <Name Value=""/>
      <Option Value="1"/>
      <FileName Value="'''+OutputPath+'''"/>
     </ExportSlb>''';
    simlab.execute(ExportSlb);

