#***************************************************************
#SimLab Version 2022.3 Beta
#Created at Tue May 23 12:01:54 2023
#***************************************************************
#Script supported for JT,NX, CATIA, Parasolid, and STEP file formats.(06/17/24)
#Script supported to handle space before body names. (06/18/24)
#Script supported to print run time in txt file (06/19/24)
#script supported to print error message in the csv if there is any failure in the particular body and proceed with other bodies. (06/20/24)

from hwx import simlab

import os

import glob

import csv

import math 

import pandas as pd

import time

import numpy as np

##Record the start time
start_time = time.time()

##Import parameter file and get the calculation logic from it
## 1 - Use global coordinates; 2 - Use body coordinates; 3 - Compare both and give dimensions with tighter package

#ImportParameters=''' <ImportParameters UUID="1c7910a2-2c5a-4618-a496-02b4bce9fc3d">
#  <FileName Value="./CalculationLogic.xml"/>
# </ImportParameters>''';
#simlab.execute(ImportParameters);

#CalculationLogic=simlab.getParameter("$CalculationLogic",False)

##Get Calculation logic from the user
CalculationLogic = input('Enter 1 for global dimensions, 2 for local dimensions and 3 for tighter package dimensions of the two:')
CalculationLogic = str(CalculationLogic)

#CalculationLogic = '1'

if CalculationLogic == '1':
    print("The body bounding box dimensions will be calculated based on Global coordinates\n")
elif CalculationLogic == '2':
    print("The body bounding box dimensions will be calculated based on the body local coordinates\n")
elif CalculationLogic == '3':
    print("The body bounding box dimensions will be calculated based on the tighter packaging among the global and local coordinates\n")
else:
    print("The Calculation Logic value must be 1, 2 or 3. The bounding box dimensions will be caluculated based on Global coordinates by default")
    CalculationLogic = '1'

##Get all .CATProduct files in the script directory
filename = glob.iglob('**/*.CATProduct', recursive=True)
catia_check = (list(filename))
##If CatProduct is empty, that means no assembly files in the directory, so get CatPart
if len(catia_check)> 0:
    list_check = catia_check
else:
    filename = glob.iglob('**/*.CATPart', recursive=True)
    list_check = (list(filename))
    
##Search for .jt files and append to list_check
jt_files = glob.iglob('**/*.jt', recursive=True)
jt_check = (list(jt_files))
list_check.extend(jt_check)

##Search for .prt (NX) files and append to list_check
NX_files = glob.iglob('**/*.prt', recursive=True)
NX_check = (list(NX_files))
list_check.extend(NX_check)

##Search for parasolid files and append to list_check
extensions = ['*.x_t', '*.x_b', '*.xmt_txt', '*.xmt_bin']
psfiles = []
for ext in extensions:
    psfiles.extend(glob.glob(f'**/{ext}', recursive=True))
list_check.extend(psfiles)

## Search for STEP files and append to list_check
step_extensions = ['*.step', '*.stp']
stpfiles = []
for ext in step_extensions:
    stpfiles.extend(glob.glob(f'**/{ext}', recursive=True))
list_check.extend(stpfiles)

#print(list_check)
# ./--/

base_path = os.getcwd()
LocalDimension = []
GlobalDimension = []
FinalDimension=[]

for modified_path in list_check:
    
    new_path = base_path+"\\"+modified_path
    new_path = new_path.replace("\\", "/")
    #print(new_path)
    
    if new_path[-11:]=='.CATProduct' or new_path[-8:]=='.CATPart':
        ##Import the CATIA file
        ImportCatia=''' <ImportCatia gda="" UUID="81027e04-fb12-4eac-a5d1-cc1880a5bb7d" CheckBox="ON">
        <tag Value="1"/>
        <Method Value="2"/>
        <Name Value=""/>
        <FileName Value="'''+new_path+'''"/>
        <Units Value="MilliMeter"/>
        <DesignParam Value="0"/>
        <Datum Value="0"/>
        <BodyName Value="1"/>
        <UsePartNameForFilesWithOneBody Value="1"/>
        <Color Value="1"/>
        <Publications Value="0"/>
        <Skethch Value="0"/>
        <Coordinates Value="0"/>
        <IncludeFiles Value="0"/>
        <Sheet Value="1"/>
        <Regenerate Value="0"/>
        <RegenModelId Value="0"/>
        <ImportAsFacets Value="0"/>
        <ImportAsmStruct Value="1"/>
        <IncludeFileNameList Value=""/>
        <SaveGeometry Value="0"/>
        <Path Value=""/>
        <Output/>
        </ImportCatia>''';
        simlab.execute(ImportCatia);
        
    elif new_path[-3:] == '.jt':
        ##Import the JT file
        JT_Import=''' <JT_Import UUID="a570051f-c5b2-49f1-936e-eae4b226148c">
        <FileName HelpStr="File name to be imported." Value="'''+new_path+'''"/>
        <SolidBodyType Value="1"/>
        <SheetBodyType Value="1"/>
        <Materials Value="0"/>
        <Groups Value="0"/>
        <Facets Value="0"/>
        <Layers Value="All Bodies"/>
        <SelectedLayer Value=""/>
        </JT_Import>''';
        simlab.execute(JT_Import);

    elif new_path[-4:] == '.prt':
        ##Import the NX file
        ImportUGNXPart=''' <ImportUGNXPart UUID="a807efb9-5c63-4ebd-8fa4-059c8970c422" pixmap="import">
        <FileName Value="'''+new_path+'''"/>
        <Units Value="MilliMeter" HelpStr="Unit to which the UG part has to be imported into SimLab" Input="MilliMeter,Meter,Inch"/>
        <ImportSolids Value="1"/>
        <ImportSheets Value="1"/>
        <ImportGroups Value="1"/>
        <Regenerate Value="0"/>
        <RegenModelId Value="0"/>
        <ImportAssemblyStructure Value="1"/>
        <DesignParameters Value="0"/>
        <ImportMaterial Value="1"/>
        </ImportUGNXPart>''';
        simlab.execute(ImportUGNXPart);
    
    elif any(new_path.endswith(ext) for ext in ['.x_t', '.x_b', '.xmt_txt', '.xmt_bin']):
        ##Import the Parasolid file
        ImportParasolid=''' <ImportParasolid UUID="400d622c-e74a-4f87-bc0b-af51659b9b6d" Type="Parasolid" gda="" CheckBox="ON">
        <tag Value="1"/>
        <Files HelpStr="Files to be imported.">
        <File Value="'''+new_path+'''"/>
        </Files>
        <Units Value="MilliMeter" HelpStr="Units to which this file is to be imported into"/>
        <SolidBodyType Value="1"/>
        <SheetBodyType Value="1"/>
        <WireBodyType Value="1"/>
        <ConnectedBodyType Value="1"/>
        <ImportasFacets Value="0"/>
        <Imprint Value="0"/>
        <Groups Value="0"/>
        <Merge Value="0"/>
        <ImportAssemblyStructure Value="1"/>
        <SaveGeometryInDatabase Value="1"/>
        <UseLighterDataStructure Value="0"/>
        <AddToExistingModel Value="0"/>
        <MassProperties Value="0"/>
        <FileCount Value="0" value="0"/>
        <Output widget="NULL"/>
        <ImportOption Value="1"/>
        <TransXmlFileName Value=""/>
        <TransOutFileName Value=""/>
        </ImportParasolid>''';
        simlab.execute(ImportParasolid);
        
    elif any(new_path.endswith(ext) for ext in ['.step', '.stp']):
        ##Import the step file
        STEP_Import=''' <STEP_Import Type="STEP" gda="" UUID="e88f2fcc-2430-4e47-9455-78b4dea9b064" CheckBox="ON">
        <FileName Value="'''+new_path+'''" HelpStr="File name to be imported." widget="LineEdit"/>
        <Method Value="External Reader"/>
        <BodyName Value="1"/>
        <ReadPartName Value="1"/>
        <SketchWireframe Value="0"/>
        <Groups Value="0"/>
        <Imprint Value="0"/>
        <Facets Value="0"/>
        <AssemblyStructure Value="1"/>
        <SaveGeometryInDatabase Value="0"/>
        </STEP_Import>''';
        simlab.execute(STEP_Import);
    
    ##Get the list of all the bodies in the model
    OutModelName1 = simlab.getModelName("CAD")
    BodyList = list(simlab.getChildrenInAssembly(OutModelName1,OutModelName1,"ALLBODIES"))
    
    ##If CalculationLogic = 1, execute the Global bounding body calculation block
    if CalculationLogic == '1' or CalculationLogic == '3':
        ##Extract Facets for the whole model
        
        ExtractFacets=''' <ExtractFacets UUID="2905919d-51aa-4337-84dc-d57dfd0dc687">
          <InputBodies>
           <Entities>
            <Model>'''+str(OutModelName1)+'''</Model>
            <Body></Body>
           </Entities>
          </InputBodies>
          <ChordalDeviationFactor Value="" Checked="0"/>
          <ChordalAngle Value="" Checked="0"/>
         </ExtractFacets>''';
        simlab.execute(ExtractFacets);
        
        ModelNameFEM = simlab.getModelName("FEM")
        BodyList_FEM = list(simlab.getChildrenInAssembly(ModelNameFEM,ModelNameFEM,"ALLBODIES"))
        
        for i in range(len(BodyList_FEM)):
            print(BodyList_FEM[i])
            try:
                ##get the node positions and calculate the distance between the extreme nodes
                ModelNameFEM = simlab.getModelName("FEM")
                
                SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
                <InputBody Values="">
                <Entities>
                    <Model>'''+str(ModelNameFEM)+'''</Model>
                    <Body>"'''+str(BodyList_FEM[i])+'''"</Body>
                </Entities>
                </InputBody>
                <Option Value="Nodes"/>
                <Groupname Value="FEM_Body_Nodes_'''+str(i)+'''"/>
                </SelectBodyAssociatedEntities>''';
                simlab.execute(SelectBodyAssociatedEntities);
                
                nFirstIter = 1
                dMinPos = []
                dMaxPos = []
                EntityIdArray = simlab.getEntityFromGroup('FEM_Body_Nodes_'+str(i))
                for NodeID in EntityIdArray:
                    dNodePos = simlab.getNodePositionFromNodeID(ModelNameFEM,NodeID)
                    if nFirstIter:
                        dMinPos.append(dNodePos[0])
                        dMinPos.append(dNodePos[1])
                        dMinPos.append(dNodePos[2])
                        dMaxPos.append(dNodePos[0])
                        dMaxPos.append(dNodePos[1])
                        dMaxPos.append(dNodePos[2])
                        nFirstIter = 0
                        continue
                    if dNodePos[0] < dMinPos[0]:
                        dMinPos[0] = dNodePos[0]
                    if dNodePos[1] < dMinPos[1]:
                        dMinPos[1] = dNodePos[1]
                    if dNodePos[2] < dMinPos[2]:
                        dMinPos[2] = dNodePos[2]
                    if dNodePos[0] > dMaxPos[0]:
                        dMaxPos[0] = dNodePos[0]
                    if dNodePos[1] > dMaxPos[1]:
                        dMaxPos[1] = dNodePos[1]
                    if dNodePos[2] > dMaxPos[2]:
                        dMaxPos[2] = dNodePos[2]
                dXLength = np.linalg.norm(dMinPos[0] - dMaxPos[0])
                dYLength = np.linalg.norm(dMinPos[1] - dMaxPos[1])
                dZLength = np.linalg.norm(dMinPos[2] - dMaxPos[2])
                
                D1= round(dXLength, 3)
                D2= round(dYLength, 3)
                D3= round(dZLength, 3)
                GlobalDimension.append([str(OutModelName1), str(BodyList[i]), str(D1).strip('()'), str(D2).strip('()'), str(D3).strip('()')])
            except Exception as e:
                print(f"An error occurred: {e}, skipping item: {e}")
                GlobalDimension.append([str(OutModelName1), str(BodyList[i]), str("Dimensions cannot be computed, please check if the CAD body is valid")])
    
        DeleteEntity=''' <DeleteEntity CheckBox="ON" UUID="BF2C866D-8983-4477-A3E9-2BBBC0BC6C2E">
        <tag Value="-1"/>
        <Name Value=""/>
        <SupportEntities>
        <Entities>
        <Model>'''+ModelNameFEM+'''</Model>
        <Body></Body>
        </Entities>
        </SupportEntities>
        <RedoFlag Value=""/>
        </DeleteEntity>''';
        simlab.execute(DeleteEntity);
        
        DeleteGroupControl=''' <DeleteGroupControl UUID="2a3b5834-9708-4b03-871c-6d05623667bd" CheckBox="ON">
        <tag Value="-1"/>
        <Name Value=""/>
        <Output/>
        </DeleteGroupControl>''';
        simlab.execute(DeleteGroupControl);
        
    ##If CalculationLogic = 2, execute the local bounding body calculation block
    if CalculationLogic == '2' or CalculationLogic == '3':
        for body_name in BodyList:
            print(body_name)
            try:
                SimplifyBodies=''' <SimplifyBodies UUID="2b37f632-84f3-4feb-a635-2c22457b30c4">
                <InputBodies>
                <Entities>
                <Model>'''+OutModelName1+'''</Model>
                <Body>"'''+str(body_name)+'''"</Body>
                </Entities>
                </InputBodies>
                <SimplificationType Value="BOX"/>
                <MeshSize Value="1000 mm"/>
                <ElementType Value="Tri3"/>
                <CreateCADParasolid Checked="0"/>
                <SimplifyEachBody Checked="1"/>
                <SimplifyContiguousBodies Checked="0"/>
                <SkipPrimitives Checked="0"/>
                <VolumePercentageLessThan Value="0" Checked="0"/>
                <SimplifyBodiesIdenticaltoInputBodies Checked="0"/>
                <SimplifyVisibleBodiesOnly Checked="0"/>
                <DeleteInputBodies Checked="0"/>
                <SuppressInputBodies Checked="0"/>
                </SimplifyBodies>''';
                simlab.execute(SimplifyBodies);
    
                OutModelName = simlab.getModelName("FEM")
                
                BodyList1 = list(simlab.getChildrenInAssembly(OutModelName,OutModelName,"ALLBODIES"))
    
                bodyname1= str(BodyList1[0])
    
                SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
                <InputBody Values="">
                <Entities>
                <Model>'''+OutModelName+'''</Model>
                <Body>"'''+bodyname1+'''"</Body>
                </Entities>
                </InputBody>
                <Option Value="Vertex"/>
                <Groupname Value="V1"/>
                </SelectBodyAssociatedEntities>''';
                simlab.execute(SelectBodyAssociatedEntities);
                
                VertexIDs_1 = list(simlab.getEntityFromGroup('V1'))
                
                ###Use the same logic used for Global body in the simplified box to get the local XYZ
                #nFirstIter = 1
                #dMinPos = []
                #dMaxPos = []
                #EntityIdArray = simlab.getEntityFromGroup('V1')
                #for vertexID in EntityIdArray:
                #    dVertexPos = simlab.getVertexPositionFromVertexID(OutModelName,vertexID)
                #    if nFirstIter:
                #        dMinPos.append(dVertexPos[0])
                #        dMinPos.append(dVertexPos[1])
                #        dMinPos.append(dVertexPos[2])
                #        dMaxPos.append(dVertexPos[0])
                #        dMaxPos.append(dVertexPos[1])
                #        dMaxPos.append(dVertexPos[2])
                #        nFirstIter = 0
                #        continue
                #    if dVertexPos[0] < dMinPos[0]:
                #        dMinPos[0] = dVertexPos[0]
                #    if dVertexPos[1] < dMinPos[1]:
                #        dMinPos[1] = dVertexPos[1]
                #    if dVertexPos[2] < dMinPos[2]:
                #        dMinPos[2] = dVertexPos[2]
                #    if dVertexPos[0] > dMaxPos[0]:
                #        dMaxPos[0] = dVertexPos[0]
                #    if dVertexPos[1] > dMaxPos[1]:
                #        dMaxPos[1] = dVertexPos[1]
                #    if dVertexPos[2] > dMaxPos[2]:
                #        dMaxPos[2] = dVertexPos[2]
                #D1 = np.linalg.norm(dMinPos[0] - dMaxPos[0])
                #D2 = np.linalg.norm(dMinPos[1] - dMaxPos[1])
                #D3 = np.linalg.norm(dMinPos[2] - dMaxPos[2])
    
                ##get the vertex entities and traverse one of them
                
                SelectVertexAssociatedEntities=''' <SelectVertexAssociatedEntities UUID="fc2ece8b-b6e8-4d37-8e27-39a13700fbad">
                <InputVertices Values="">
                <Entities>
                <Model>'''+OutModelName+'''</Model>
                <Body>"'''+bodyname1+'''"</Body>
                <Vertex>'''+str(VertexIDs_1[0])+''',</Vertex>
                </Entities>
                </InputVertices>
                <Option Value="Edges"/>
                <Groupname Value="SelectEdges"/>
                </SelectVertexAssociatedEntities>''';
                simlab.execute(SelectVertexAssociatedEntities);
                
                ##get entities from the edge group and find associated vertices:
                
                
                EdgeIDs = list(simlab.getEntityFromGroup('SelectEdges'))
                
                for i in range(len(EdgeIDs)):
                
                    SelectEdgeAssociatedEntities=''' <SelectEdgeAssociatedEntities UUID="551fdd5b-6a8c-4a30-8ab0-fbaf9257343e">
                    <InputEdges Values="">
                    <Entities>
                    <Model>'''+OutModelName+'''</Model>
                    <Body>"'''+bodyname1+'''"</Body>
                    <Edge>'''+str(EdgeIDs[i])+'''</Edge>
                    </Entities>
                    </InputEdges>
                    <Option Value="Vertex"/>
                    <Groupname Value="VertexGroup_'''+str(i)+'''"/>
                    </SelectEdgeAssociatedEntities>''';
                    simlab.execute(SelectEdgeAssociatedEntities);
                
                
                
                #VCenter1 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_1[0]))
                
                VertexIDs_1 = list(simlab.getEntityFromGroup('VertexGroup_0'))
                
                VertexIDs_2 = list(simlab.getEntityFromGroup('VertexGroup_1'))
                
                VertexIDs_3 = list(simlab.getEntityFromGroup('VertexGroup_2'))
                
                C1 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_1[0]))
                
                C2 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_1[1]))
                
                D1 = math.sqrt((C1[0] - C2[0])**2 + (C1[1] - C2[1])**2 + (C1[2] - C2[2])**2)
                
                C3 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_2[0]))
                
                C4 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_2[1]))
                
                D2 = math.sqrt((C3[0] - C4[0])**2 + (C3[1] - C4[1])**2 + (C3[2] - C4[2])**2)
                
                C5 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_3[0]))
                
                C6 = list(simlab.getVertexPositionFromVertexID(OutModelName,VertexIDs_3[1]))
                
                D3 = math.sqrt((C5[0] - C6[0])**2 + (C5[1] - C6[1])**2 + (C5[2] - C6[2])**2)
    
                DeleteEntity=''' <DeleteEntity CheckBox="ON" UUID="BF2C866D-8983-4477-A3E9-2BBBC0BC6C2E">
                <tag Value="-1"/>
                <Name Value=""/>
                <SupportEntities>
                <Entities>
                <Model>'''+OutModelName+'''</Model>
                <Body></Body>
                </Entities>
                </SupportEntities>
                <RedoFlag Value=""/>
                </DeleteEntity>''';
                simlab.execute(DeleteEntity);
                
                DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
                <tag Value="-1"/>
                <Name Value=""/>
                <Output/>
                </DeleteGroupControl>''';
                simlab.execute(DeleteGroupControl);
            
    
            ##GET EACH OF THE ENTITIES FROM THE VERTEX GROUP:
    
            #BoundingBody_Dimensions = [ OutModelName , D1 , D2 , D3]
    
            ##Construct the row manually
            #LocalDimension = [str(OutModelName), str(D1).strip('()'), str(D2).strip('()'), str(D3).strip('()')]
    
            
                D1= round(D1, 3)
                D2= round(D2, 3)
                D3= round(D3, 3)
                LocalDimension.append([str(OutModelName1), str(body_name), str(D1).strip('()'), str(D2).strip('()'), str(D3).strip('()')])
                
            except Exception as e:
                print(f"An error occurred: {e}, skipping item: {e}")
                LocalDimension.append([str(OutModelName1), str(body_name), str("Dimensions cannot be computed, please check if the CAD body is valid")])
                
    ##Close the current model and open the new model from the list_check
    simlab.closeActiveDocument();
    simlab.newDocument()

if CalculationLogic == '1':
    FinalDimension = GlobalDimension
elif CalculationLogic == '2':
    FinalDimension = LocalDimension
elif CalculationLogic == '3':
    ##Compute the volume of both the Global and Local dimensions and append the tighter packaging dimensions to the FinalDimension
    if len(GlobalDimension) == len(LocalDimension):
        for i in range(len(GlobalDimension)):
            if len(GlobalDimension[i]) == 5 and len(LocalDimension[i]) == 5:
                GlobalBBVolume = round(float(GlobalDimension[i][2])*float(GlobalDimension[i][3])*float(GlobalDimension[i][4]), 3)
                LocalBBVolume = round(float(LocalDimension[i][2])*float(LocalDimension[i][3])*float(LocalDimension[i][4]), 3)
                if GlobalBBVolume <= LocalBBVolume:
                    FinalDimension.append(GlobalDimension[i])
                else:
                    FinalDimension.append(LocalDimension[i])
            else:
                ##For invalid models, instead of dimensions message will be written in the csv. So, write the same message for the model in the FinalDimension
                if len(GlobalDimension[i]) < len(LocalDimension[i]):
                    FinalDimension.append(GlobalDimension[i])
                else:
                    FinalDimension.append(LocalDimension[i])
    else:
        ##If GlobalDimension and LocalDimension are of different length, that means something is wrong and hence both the lists are printed for debugging
        print("LocalDimension entries and Global Dimension entries are different. So unable to compare. Printing both the entries for debugging")
        with open('Global_BoundingBody_Dimensions.csv', 'w', newline='') as file:
            writer = csv.writer(file)
            writer.writerow(['ModelName','Bodyname','D1', 'D2', 'D3'])
            writer.writerows(GlobalDimension)
        with open('Local_BoundingBody_Dimensions.csv', 'w', newline='') as file:
            writer = csv.writer(file)
            writer.writerow(['ModelName','Bodyname','D1', 'D2', 'D3'])
            writer.writerows(LocalDimension)
    
def get_unique_filename(npath):
    ##Generate a unique file name by appending a number if the base file already exists
    if not os.path.exists(npath):
        return npath
    
    base, ext = os.path.splitext(npath)
    counter = 1
    revised_path = f"{base}_{counter}{ext}"
    while os.path.exists(revised_path):
        counter += 1
        revised_path = f"{base}_{counter}{ext}"
    return revised_path

##File path where you want to save the CSV
file_path = 'BoundingBody_Dimensions.csv'
file_path = get_unique_filename(file_path)

##Writing the list to CSV
with open(file_path, 'w', newline='') as file:
    writer = csv.writer(file)
    writer.writerow(['ModelName','Bodyname','D1', 'D2', 'D3'])
    writer.writerows(FinalDimension)
    
# # Load the CSV file into a DataFrame
# updated_file_path = file_path  # Replace with the path to your CSV file
# df = pd.read_csv(updated_file_path)

# # Remove duplicate rows
# df_cleaned = df.drop_duplicates()

# # Save the cleaned DataFrame to a new CSV file
# output_file_path = 'BoundingBody_Dimensions_withoutDuplicateNames.csv'  # Replace with the desired output file path
# updated_file_path = get_unique_filename(output_file_path)
# df_cleaned.to_csv(updated_file_path, index=False)

df = None
try:
    df = pd.read_csv(file_path, encoding='utf-8')
except UnicodeDecodeError:
    try:
        df = pd.read_csv(file_path, encoding='latin1')
    except UnicodeDecodeError:
        try:
            df = pd.read_csv(file_path, encoding='iso-8859-1')
        except UnicodeDecodeError:
            print("Failed to read the file with utf-8, latin1, and iso-8859-1 encodings.")
            exit(1)

if df is not None:
    ##Remove duplicate rows
    df_cleaned = df.drop_duplicates()

    ##Save the cleaned DataFrame to a new CSV file
    output_file_path = 'BoundingBody_Dimensions_withoutDuplicateNames.csv'
    updated_file_path = get_unique_filename(output_file_path) #Replace with the desired output file path
    df_cleaned.to_csv(updated_file_path, index=False)

    print(f"Bounding body dimensions without duplicates has been saved to {updated_file_path}")
else:
    print("Failed to load the DataFrame.")
    
end_time = time.time()

##Calculate the runtime and print to a text file
runtime = end_time - start_time
print(f"Script runtime: {runtime} seconds")
script_dir = os.path.dirname(os.path.abspath(__file__))
output_file = os.path.join(script_dir, 'runtime.txt')
with open(output_file, 'w') as file:
    file.write(f"Script runtime: {runtime} seconds")
#print(f"Runtime written to {output_file}")

#fin