#***************************************************************
#SimLab Version 2024 Beta
#Created at Wed Apr 17 14:45:56 2024
#***************************************************************
from hwx import simlab
import os

UnitSystem=''' <UnitSystem UUID="3aca8564-4d38-4b0b-887c-6a542d4001c6">
  <SetCurrentDisplaySystem Name="MMKS (mm kg N C s)"/>
 </UnitSystem>''';
simlab.execute(UnitSystem);

FEMModelName=simlab.getModelName("FEM")

CreateGroup=''' <CreateGroup CheckBox="OFF" isObject="4" UUID="899db3a6-bd69-4a2d-b30f-756c2b2b1954">
  <tag Value="-1"/>
  <Name Value="Rib_faces" OldValue=""/>
  <SupportEntities>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Face>'''+Rib_faces+'''</Face>
   </Entities>
  </SupportEntities>
  <Type Value="Face"/>
  <Color Value="255,206,0,"/>
  <Dup Value="0"/>
 </CreateGroup>''';
simlab.execute(CreateGroup);

CreateGroup=''' <CreateGroup UUID="899db3a6-bd69-4a2d-b30f-756c2b2b1954" isObject="4" CheckBox="OFF">
  <tag Value="-1"/>
  <Name Value="InitialBodies" OldValue=""/>
  <SupportEntities>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <Type Value="Body"/>
  <Color Value="255,0,255,"/>
  <Dup Value="0"/>
 </CreateGroup>''';
simlab.execute(CreateGroup);

CreateBodyFromFaces=''' <BodyFromFaces UUID="24F7C671-DC40-44e0-9B32-8A22A67F58FA" gda="">
  <SupportEntities ModelIds="" EntityTypes="" Value=""/>
  <ShareBoundaryEdges Value="0"/>
  <CreateBodyFromFaceOption Value="2"/>
  <CreateBodyForEachGroup Value="false"/>
  <Group Entity="" Value="Rib_faces,"/>
  <UseInputBodyName Value="true"/>
  <RedoFlag Value=""/>
 </BodyFromFaces>''';
simlab.execute(CreateBodyFromFaces);

Node1=Node1.strip(',')
Node2=Node2.strip(',')

Coord1 = simlab.getNodePositionFromNodeID(FEMModelName,int(Node1))
Coord2 = simlab.getNodePositionFromNodeID(FEMModelName,int(Node2))

Dirn=[0,0,1]
Dirn[0]=Coord2[0]-Coord1[0]
Dirn[1]=Coord2[1]-Coord1[1]
Dirn[2]=Coord2[2]-Coord1[2]

Translation=''' <Translation UUID="26b085e8-d9a3-4baf-95f2-9f3eb75ac454" CheckBox="ON">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>"Rib_faces",</Body>
   </Entities>
  </SupportEntities>
  <RegionObject>
   <TranslationDirection>
    <DirectionVector Value="'''+str(Dirn).strip('[]')+''',"/>
   </TranslationDirection>
  </RegionObject>
  <UnitVector Value="0"/>
  <Magnitude Value="1"/>
  <DistanceVector Value="'''+RibDistance+'''"/>
  <CoorId Value="0"/>
  <Copy Value="0"/>
  <WithLBC Value="0"/>
  <No.Of.Copies Value="1"/>
  <LocalCoordinateSystem Value=""/>
  <Output/>
 </Translation>''';
simlab.execute(Translation);

UpdatedNoOfRibs = int(NoOfRibs) - 1

Translation=''' <Translation UUID="26b085e8-d9a3-4baf-95f2-9f3eb75ac454" CheckBox="ON">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>"Rib_faces",</Body>
   </Entities>
  </SupportEntities>
  <RegionObject>
   <TranslationDirection>
    <DirectionVector Value="'''+str(Dirn).strip('[]')+''',"/>
   </TranslationDirection>
  </RegionObject>
  <UnitVector Value="0"/>
  <Magnitude Value="1"/>
  <DistanceVector Value="'''+RibDistance+'''"/>
  <CoorId Value="0"/>
  <Copy Value="1"/>
  <WithLBC Value="0"/>
  <No.Of.Copies Value="'''+str(UpdatedNoOfRibs)+'''"/>
  <LocalCoordinateSystem Value=""/>
  <Output/>
 </Translation>''';
simlab.execute(Translation);

CreateGroup=''' <CreateGroup UUID="899db3a6-bd69-4a2d-b30f-756c2b2b1954" isObject="4" CheckBox="OFF">
  <tag Value="-1"/>
  <Name Value="OverallBodies" OldValue=""/>
  <SupportEntities>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body></Body>
   </Entities>
  </SupportEntities>
  <Type Value="Body"/>
  <Color Value="255,0,255,"/>
  <Dup Value="0"/>
 </CreateGroup>''';
simlab.execute(CreateGroup);

BooleanGroup=''' <BooleanGroup UUID="5da8b41c-208b-4968-a282-9763c2258878">
  <tag Value="-1"/>
  <Name Value="Rib_Bodies"/>
  <Type Value="Body"/>
  <UseExtisingGroup Value=""/>
  <Operation Value="Difference"/>
  <GroupList1 Value="OverallBodies,"/>
  <GroupList2 Value="InitialBodies,"/>
 </BooleanGroup>''';
simlab.execute(BooleanGroup);

MergeBodies=''' <BodyMerge UUID="FA9128EE-5E6C-49af-BADF-4016E5622020" gda="">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Group>"Rib_Bodies",</Group>
  </SupportEntities>
  <Delete_Shared_Faces Value="0"/>
  <Output_Body_Name Value="MergedRibs"/>
  <RedoFlag Value=""/>
  <Output/>
 </BodyMerge>''';
simlab.execute(MergeBodies);

SelectFaceAssociatedEntities=''' <SelectFaceAssociatedEntities UUID="4128ad97-7527-4dad-9746-470cfa135434">
  <InputFaces Values="">
   <Group>"Rib_faces",</Group>
  </InputFaces>
  <Option Value="Bodies"/>
  <Groupname Value="BaseBody"/>
 </SelectFaceAssociatedEntities>''';
simlab.execute(SelectFaceAssociatedEntities);

BaseBodyNames = simlab.getBodiesFromGroup('BaseBody')

BaseBodyString='' 

for body in BaseBodyNames:
    BaseBodyString=BaseBodyString+'"'+body+'",'

ModifyElements=''' <Modify UUID="28706164-e6e5-4544-b4a9-c052c4b6c60f" CheckBox="ON">
  <Name Value="Modify1"/>
  <tag Value="-1"/>
  <Option Value="QUADTOTRI"/>
  <QuadDominant Value="1"/>
  <Entity>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>'''+BaseBodyString+'''"MergedRibs",</Body>
   </Entities>
  </Entity>
  <IdealQuad Value="0"/>
  <UpdateAssociateRBENodes Value="1"/>
 </Modify>''';
simlab.execute(ModifyElements);

ReplaceFace=''' <ReplaceFace UUID="a4541abf-d412-423b-9d43-a0ac260fa83a">
  <NewFaces>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>"MergedRibs",</Body>
   </Entities>
  </NewFaces>
  <CurrentFaces>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>'''+BaseBodyString+'''</Body>
   </Entities>
  </CurrentFaces>
  <MovableNodes EntityTypes="" ModelIds="" Value="">
   <Entities>
    <Model/>
    <Node/>
   </Entities>
  </MovableNodes>
  <FixedNodes EntityTypes="" ModelIds="" Value="">
   <Entities>
    <Model/>
    <Node/>
   </Entities>
  </FixedNodes>
  <NumSolidLayers Value="0"/>
  <MakeCopy Value="0"/>
  <LocalRemeshOption flag="false"/>
  <MeshSize Value="0 mm"/>
 </ReplaceFace>''';
simlab.execute(ReplaceFace);

SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
  <InputBody Values="">
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>'''+BaseBodyString+'''</Body>
   </Entities>
  </InputBody>
  <Option Value="Faces"/>
  <Groupname Value="BaseBodyFaces"/>
 </SelectBodyAssociatedEntities>''';
simlab.execute(SelectBodyAssociatedEntities);

MinElemSize = int(QuadMeshSize)/10

SurfaceLocalRemesh=''' <NewLocalReMesh UUID="83ab93df-8b5e-4a48-a209-07ed417d75bb">
  <tag Value="-1"/>
  <Name Value="NewLocalReMesh1"/>
  <SupportEntities>
   <Group>"BaseBodyFaces",</Group>
  </SupportEntities>
  <ElemType Value="2"/>
  <AverageElemSize Value="2 mm"/>
  <MinElemSize Value="0.2 mm"/>
  <PreserveBoundaryEdges Value="0"/>
  <NumberOfSolidLayersToUpdate Value="3"/>
  <TriOption>
   <GradeFactor Value="0"/>
   <MaxAnglePerElem Value="0"/>
   <CurvatureMinElemSize Value="0"/>
   <AspectRatio Value="0"/>
   <AdvancedOptions>
    <MappedMesh Value="0"/>
    <MeshPattern Value="0"/>
    <ReMeshSharedEntity Value="0"/>
    <CADLocalReMesh Value="0"/>
   </AdvancedOptions>
  </TriOption>
  <QuadOption>
   <QuadMeshType Value="4"/>
   <HM_Quad_Mesh Value="1">
    <AverageElementSize Value="'''+QuadMeshSize+'''"/>
    <MinimumElementSize Value="'''+str(MinElemSize)+'''"/>
    <AllowQuadMeshTransition Checked="0"/>
    <ProjectToSelectedEntities Checked="0"/>
   </HM_Quad_Mesh>
  </QuadOption>
 </NewLocalReMesh>''';
simlab.execute(SurfaceLocalRemesh);

DeleteEntity=''' <DeleteEntity CheckBox="ON" UUID="BF2C866D-8983-4477-A3E9-2BBBC0BC6C2E">
  <tag Value="-1"/>
  <Name Value=""/>
  <SupportEntities>
   <Entities>
    <Model>'''+FEMModelName+'''</Model>
    <Body>"MergedRibs",</Body>
   </Entities>
  </SupportEntities>
  <RedoFlag Value=""/>
 </DeleteEntity>''';
simlab.execute(DeleteEntity);

##############################################################################

#SurfaceMesh=''' <SurfaceMesh UUID="08df0ff6-f369-4003-956c-82781326c876">
#  <tag Value="-1"/>
#  <SurfaceMeshType Value="Quad"/>
#  <SupportEntities>
#   <Entities>
#    <Model>'''+FEMModelName+'''</Model>
#    <Body>'''+BaseBodyString+'''</Body>
#   </Entities>
#  </SupportEntities>
#  <Quad Type="HMQuad">
#   <AverageElementSize Value="2 mm"/>
#   <MinimumElementSize Value="0.2 mm"/>
#   <AllowQuadMeshTransition Checked="0"/>
#   <ProjectToSelectedEntities Checked="0"/>
#  </Quad>
# </SurfaceMesh>''';
#simlab.execute(SurfaceMesh);

#ExportSlb=''' <ExportSlb UUID="a155cd6e-8ae6-4720-8ab4-1f50d4a34d1c">
#  <tag Value="-1"/>
#  <Name Value=""/>
#  <Option Value="1"/>
#  <Duplicate Value="0"/>
#  <FileName Value="./../../../rib_form_output.slb"/>
# </ExportSlb>''';
#simlab.execute(ExportSlb);