#***************************************************************
#SimLab Version 2023 Beta
#Created at Fri May  5 16:43:45 2023
#***************************************************************
from hwx import simlab


m_MoldeName=simlab.getParentModelFromSelectedEntities("Body")
BodyCount=len(InputBodyList)
InputBodyList=str(InputBodyList).strip(",")
InputBodyList=str(InputBodyList).split(",")
dMeshSize=float(m_dMeshSize)

InputBodies=''
if BodyCount>0:
    InputBodies=str(InputBodyList).strip("[]").replace("'",'')

#SubString=[sSetName]
#OutputGroupNameList=simlab.getSetsWithSubString("SolidElementFace", SubString);

SurfaceMesh=''' <SurfaceMesh UUID="08df0ff6-f369-4003-956c-82781326c876">
  <tag Value="-1"/>
  <SurfaceMeshType Value="Tri"/>
  <SupportEntities>
   <Entities>
    <Model>'''+m_MoldeName+'''</Model>
    <Body>'''+InputBodies+'''</Body>
   </Entities>
  </SupportEntities>
  <Tri>
   <ElementType Value="Tri3"/>
   <AverageElementSize Value="'''+str(dMeshSize)+'''" Checked="1"/>
   <MaximumElementSize Value="2.121 mm" Checked="0"/>
   <MinimumElementSize Value="'''+str(dMeshSize/10)+'''"/>
   <GradeFactor Value="1.5"/>
   <MaximumAnglePerElement Value="45 deg"/>
   <CurvatureMinimumElementSize Value="'''+str(dMeshSize/2)+'''"/>
   <AspectRatio Value="10"/>
   <IdentifyFeaturesAndMesh Checked="1"/>
   <MergeTinyFillets Checked="1"/>
   <CreateMatchingMesh Checked="0"/>
   <AdvancedOptions>
    <ImprintMeshing Checked="0"/>
    <BetterGeometryApproximation Checked="0"/>
    <CoarseMesh Checked="0"/>
    <CoarseMesh_UseExistingNodes Checked="0"/>
    <CreateNewMeshModel Checked="0"/>
    <UserDefinedModelName Value=""/>
    <Tri6WithStraightEdges Checked="0"/>
    <ImproveSkewAngle Value="0"/>
    <MappedMesh Value="0"/>
    <MeshPattern Value="0"/>
    <SkipIntersectionCleanup Checked="0"/>
   </AdvancedOptions>
  </Tri>
 </SurfaceMesh>''';
simlab.execute(SurfaceMesh);

GroupList=1

while GroupList!=0:

    SubString=["CCMC-*"]
    OutputGroupNameList=simlab.getGroupsWithSubString("FaceGroup", SubString);
    
    SetName=OutputGroupNameList[0].split("-")[1]
    
    SubString=["CCMC-"+SetName+"*"]
    OutputGroupNameList=simlab.getGroupsWithSubString("FaceGroup", SubString);
    
    Sets=''' <SetsDlg BCType="Sets" CheckBox="ON" customselection="1" pixmap="sets" UUID="c54659af-2627-4c1a-b516-f5312356c88d" isObject="2">
      <tag Value="-1"/>
      <Name Value="'''+str(SetName)+'''"/>
      <SetID Value="1"/>
      <SetstEntities>
       <Group>'''+str(OutputGroupNameList).strip("()").replace("'",'"')+''',</Group>
      </SetstEntities>
      <masterSupportEntities EntityTypes="" ModelIds="" Value=""/>
      <slaveSupportEntities EntityTypes="" ModelIds="" Value=""/>
      <SetType Value="Solid Elem Face"/>
      <EntityType Value="Face"/>
      <EntityID Value=""/>
      <nodeaset Value=""/>
      <nodeaset1 Value=""/>
      <one Value=""/>
      <two Value=""/>
      <three Value=""/>
      <four Value=""/>
      <five Value=""/>
      <six Value=""/>
      <LinearCheck Value=""/>
      <TabIndex Value=""/>
      <Tolerance Value=""/>
      <ContactFaceIndex Value=""/>
      <TrimOption Value="-1"/>
      <MasterSetName Value=""/>
      <SlaveSetName Value=""/>
      <SetTypeIndex Value=""/>
      <MapEntities Value=""/>
      <MeshCtrlCheck Value=""/>
      <SetCtrlCheck Value=""/>
      <GrpCtrlCheck Value=""/>
      <Options Value=""/>
      <CadModelCheck Value=""/>
      <MaxId Value=""/>
      <MinId Value=""/>
      <AxisID Value=""/>
      <RegionType Value=""/>
      <RegionX Value=""/>
      <RegionY Value=""/>
      <RegionZ Value=""/>
      <Node_IncMidNodes Value=""/>
      <SurfNodes Value=""/>
      <IncSolidElemIsAttachFaceNodes Value=""/>
      <NumSolidElemLayers Value=""/>
      <IsRegionType Value="-1"/>
      <IsRegionDefined Value="-1"/>
      <RegnOption Value="-1"/>
      <MemLayerConnMidNodesCheck Value=""/>
      <ReducedIntegrationMembraneElements Value=""/>
      <Output/>
     </SetsDlg>''';
    simlab.execute(Sets);
    
    DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
      <tag Value="-1"/>
      <Name Value="'''+str(OutputGroupNameList).strip("()").replace("'","")+''',"/>
      <Output/>
     </DeleteGroupControl>''';
    simlab.execute(DeleteGroupControl);
    
    SubString=["CCMC-*"]
    OutputGroupNameList=simlab.getGroupsWithSubString("FaceGroup", SubString);
    
    GroupList=len(OutputGroupNameList)
    
SubString=["CCMC-*"]
OutputGroupNameList=simlab.getGroupsWithSubString("EdgeGroup", SubString);


DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
  <tag Value="-1"/>
  <Name Value="'''+str(OutputGroupNameList).strip("()").replace("'","")+''',"/>
  <Output/>
 </DeleteGroupControl>''';
simlab.execute(DeleteGroupControl);

