#***************************************************************
#SimLab Version 2023 Beta
#Created at Fri May  5 16:43:45 2023
#***************************************************************
from hwx import simlab

UnitSystem=''' <UnitSystem UUID="3aca8564-4d38-4b0b-887c-6a542d4001c6">
  <SetCurrentDisplaySystem Name="MMKS (mm kg N C s)"/>
 </UnitSystem>''';
simlab.execute(UnitSystem);

#m_Face=str(m_Face).strip(",")

m_MoldeName=simlab.getParentModelFromSelectedEntities("Edge")
m_Edges=str(m_Edges).strip(",")
m_Edges=str(m_Edges).split(",")
nCircles=int(m_nCircles)
dOffset=float(m_dOffsetDist)
dMeshSize=float(m_dMeshSize)
sSetName=str(SetName)

if "-" in sSetName:
    msgBox = simlab.pauseprocess('Do not use "-" in Mesh control name, please rename it or instead use "_" and try again.',title="SimLab Error",Button1="OK",Button2="Close")
    
else:
    
    InputBodyList=[]
    j=1
    
    for i in m_Edges:
    
        SelectEdgeAssociatedEntities=''' <SelectEdgeAssociatedEntities UUID="551fdd5b-6a8c-4a30-8ab0-fbaf9257343e">
          <InputEdges Values="">
           <Entities>
            <Model>'''+m_MoldeName+'''</Model>
            <Edge>'''+str(i)+''',</Edge>
           </Entities>
          </InputEdges>
          <Option Value="Faces"/>
          <Groupname Value="ArcFaces"/>
         </SelectEdgeAssociatedEntities>''';
        simlab.execute(SelectEdgeAssociatedEntities);
        
        SelectFaceAssociatedEntities=''' <SelectFaceAssociatedEntities UUID="4128ad97-7527-4dad-9746-470cfa135434">
          <InputFaces Values="">
           <Group>"ArcFaces",</Group>
          </InputFaces>
          <Option Value="Bodies"/>
          <Groupname Value="InputBody"/>
         </SelectFaceAssociatedEntities>''';
        simlab.execute(SelectFaceAssociatedEntities);
        
        InputBody = simlab.getBodiesFromGroup('InputBody')
        InputBodyList.append(InputBody[0])
        
        SelectFeatures=''' <SelectFeatures CheckBox="ON" UUID="CF82E8FB-9B3E-4c02-BA93-9466C1342C6E">
          <SupportEntities>
           <Group>"ArcFaces",</Group>
          </SupportEntities>
          <Arcs MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <ArcsAll Value="0"/>
          <Circles MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <CirclesAll Value="0"/>
          <Cones MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <ConeAll Value="0"/>
          <FullCone Value="0"/>
          <ClosedPartialCone Value="0"/>
          <OpenPartialCone Value="0"/>
          <TaperAngle Value="0" Angle="0 deg"/>
          <Dics MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <DicsAll Value="0"/>
          <HollowDics MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <HollowDicsAll Value="0"/>
          <Cylinders MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <CylindersAll Value="0"/>
          <FullCylinder Value="0"/>
          <ClosedPartialCylinder Value="0"/>
          <OpenPartialCylinder Value="0"/>
          <Fillets MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <FilletsOption Value="1"/>
          <PlanarFaces Value="1"/>
          <FourEdgedFaces Value="0"/>
          <ConnectedCoaxialFaces Value="0"/>
          <ThroughBoltHole MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <BlindBoltHole MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <BlindBoltHoleDepth MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <SlotEdges MinValue="0 mm" Value="0" MaxValue="0 mm"/>
          <SlotEdgesAll Value="0"/>
          <ArcLengthBased Value=""/>
          <AngleBased Value=""/>
          <SharpEdges Value="" Option="" Angle=""/>
          <ThicknessBased Value=""/>
          <LogosAndDetails Value=""/>
          <LogosAndDetailsThickness Value=""/>
          <CreateGrp Name="InputFace" Value="1"/>
         </SelectFeatures>''';
        simlab.execute(SelectFeatures);
    
        ArcCenterPt,Rad = simlab.getArcEdgeAttributes(m_MoldeName,int(i))
        ArcCenterPt=str(ArcCenterPt).strip('()')
        ArcCenterPt=str(ArcCenterPt).split(",")
        
        if nCircles>0:
            for i in range(1, nCircles+1, 1):
                dRadius=float(m_dRadius)
                dRadius=dRadius+(dOffset*(i-1))
                nSeed=int(2*3.14*dRadius/dMeshSize)
                MeshControlName= "CCMC-"+sSetName+"-"+str(j)
        
                MeshControls=''' <MeshControl isObject="1" UUID="1cb8a11b-39b0-417e-80b5-fa99a34ce8d3" CheckBox="ON">
                  <tag Value="-1"/>
                  <MeshControlName Value="'''+str(MeshControlName)+'''"/>
                  <MeshControlType Value="Imprint Circle"/>
                  <Entities>
                   <Group>"InputFace",</Group>
                  </Entities>
                  <Reverse ModelIds="" EntityTypes="" Value=""/>
                  <MeshColor Value=""/>
                  <ImprintCircle>
                   <CentreX Value="'''+str(ArcCenterPt[0])+''' mm"/>
                   <CentreY Value="'''+str(ArcCenterPt[1])+''' mm"/>
                   <CentreZ Value="'''+str(ArcCenterPt[2])+''' mm"/>
                   <Radius Value="'''+str(dRadius)+''' mm"/>
                   <Scale Value="1"/>
                   <CircularRadius Value="'''+str(dRadius)+''' mm"/>
                   <CircularDivisions Value="'''+str(nSeed)+'''"/>
                  </ImprintCircle>
                 </MeshControl>''';
                simlab.execute(MeshControls);
                
                j=j+1
                
        DeleteGroupControl=''' <DeleteGroupControl CheckBox="ON" UUID="2a3b5834-9708-4b03-871c-6d05623667bd">
          <tag Value="-1"/>
          <Name Value="ArcFaces,InputFace,InputBody"/>
          <Output/>
         </DeleteGroupControl>''';
        simlab.execute(DeleteGroupControl);
    
    TempDir=simlab.getSimlabScratchDir()
        
    with open(TempDir+"/customui_LogFile.txt",'r') as file:
        for lines in file:
            if "Local mesh attribute with this name already exists" in lines:
                msgBox = simlab.pauseprocess('Defined Mesh Control name is already used, please append with _1,2,3.., and try again.',title="SimLab Error",Button1="OK",Button2="Close")
                break  
        file.close()

