#***************************************************************
#SimLab Version 2022 
#Created at Fri Jun 10 12:38:08 2022
#***************************************************************
#For debugging this python script,Please comment(#) out the line "from hwx import simlab" and uncomment the line "import simlab"
#import simlab
from hwx import simlab

RBEBodies=simlab.getSelectedBodies()

ModelName = simlab.getModelName("FEM")

if len(RBEBodies) == 2:
    
    SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
      <InputBody Values="">
       <Entities>
        <Model>'''+ModelName+'''</Model>
        <Body>"'''+str(RBEBodies[0])+'''",</Body>
       </Entities>
      </InputBody>
      <Option Value="Nodes"/>
      <Groupname Value="TempNode1"/>
      <RBECenterNode Value="1"/>
      <RBEDependantNodes Value="0"/>
     </SelectBodyAssociatedEntities>''';
    simlab.execute(SelectBodyAssociatedEntities);
    
    SelectBodyAssociatedEntities=''' <SelectBodyAssociatedEntities UUID="f3c1adc7-fbac-4d30-9b29-9072f36f1ad4">
      <InputBody Values="">
       <Entities>
        <Model>'''+ModelName+'''</Model>
        <Body>"'''+str(RBEBodies[1])+'''",</Body>
       </Entities>
      </InputBody>
      <Option Value="Nodes"/>
      <Groupname Value="TempNode2"/>
      <RBECenterNode Value="1"/>
      <RBEDependantNodes Value="0"/>
     </SelectBodyAssociatedEntities>''';
    simlab.execute(SelectBodyAssociatedEntities);
    
    Node1=simlab.getEntityFromGroup('TempNode1')
    Node2=simlab.getEntityFromGroup('TempNode2')
    k=1
    BarList=[]
    BarName=BarBodyName
    for i in Node1:
        TopNode=simlab.getNodePositionFromNodeID(ModelName,i);
        for j in Node2:
            BtNode=simlab.getNodePositionFromNodeID(ModelName,j);
            roundoff=3
            TopNode_roundoff=round(TopNode[0],roundoff),round(TopNode[1],roundoff),round(TopNode[2],roundoff)
            BtNode_roundoff=round(BtNode[0],roundoff),round(BtNode[1],roundoff),round(BtNode[2],roundoff)
            BarNodes=str(i)+","+str(j)
            
            if TopNode_roundoff[0]==BtNode_roundoff[0] or TopNode_roundoff[1]==BtNode_roundoff[1] or TopNode_roundoff[2]==BtNode_roundoff[2]:

                BarNode=BarNodes.split(",")
                
                DistanceBetweenTwoEntities=''' <DistanceBetweenTwoEntities UUID="53537c0a-6606-4b36-9a95-c05be32f39fc" >
                  <SupportEntity1>
                   <Entities>
                    <Model>'''+ModelName+'''</Model>
                    <Node>'''+str(BarNode[0])+'''</Node>
                   </Entities>
                  </SupportEntity1>
                <SupportEntity2>
                   <Entities>
                    <Model>'''+ModelName+'''</Model>
                    <Node>'''+str(BarNode[1])+'''</Node>
                   </Entities>
                  </SupportEntity2>
                 </DistanceBetweenTwoEntities>''';
                Distance,Del_x,Del_y,Del_z=simlab.measure(DistanceBetweenTwoEntities);                
                P=False
               
                if round(Distance[0],2) <= float(Tolerance):
                    
                    P=True
                    BarNodes=str(i)+","+str(j)
                    
                    CreateBar=''' <Bar UUID="741D7A3A-1CD4-4051-ABBA-CD1603D1C545" CheckBox="ON">
                      <tag Value="-1"/>
                      <Name Value="'''+str(BarName)+'''"/>
                      <SupportEntities>
                       <Entities>
                        <Model>'''+ModelName+'''</Model>
                        <Node>'''+str(BarNodes)+ '''</Node>
                       </Entities>
                      </SupportEntities>
                      <Output/>
                     </Bar>''';
                    simlab.execute(CreateBar);
    
                    BarList.append(BarName)
                    BarName=BarBodyName+str(k)  
                    k = k+1;
                    
                if P==True:
                    break

    BodyMergeRightClick=''' <BodyMergeRightClick UUID="7d2fbe6f-4dd7-4848-8cb5-f8be2d72c418" CheckBox="ON">
      <tag Value="-1"/>
      <ModelId Value=""/>
      <BodyId>
       <Entities>
        <Model>'''+ModelName+'''</Model>
        <Body>'''+str(BarList).strip('()').replace("'",'"')+''',</Body>
       </Entities>
      </BodyId>
      <RedoFlag Value=""/>
      <Output/>
     </BodyMergeRightClick>''';
    simlab.execute(BodyMergeRightClick);    

    DeleteGroupControl=''' <DeleteGroupControl UUID="2a3b5834-9708-4b03-871c-6d05623667bd" CheckBox="ON">
      <tag Value="-1"/>
      <Name Value="TempNode1,TempNode2,"/>
      <Output/>
     </DeleteGroupControl>''';
    simlab.execute(DeleteGroupControl);
    
    CreateMaterial=''' <Material CreateAsDBMaterial="true" UUID="dd7920e8-5d0f-477b-bc7e-037a04a7ed03" Hide="2">
      <tag Value="-1"/>
      <Name Value="Steel"/>
      <MaterialId Value="3"/>
      <Category Value="Solid"/>
      <Class Value="Metal"/>
      <Model Value="Isotropic" UnitSystem=""/>
      <SupportEntities/>
      <TableData>
       <CATEGORY NAME="Common Properties">
        <ITEM KEY="Density" DISPLAYNAME="Density">
         <COLUMN UNIT="density" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="7.85e-06 kg/mm3"/>
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
       </CATEGORY>
       <CATEGORY NAME="Mechanical Properties">
        <CATEGORY NAME="Elastic">
         <ITEM KEY="Youngs_modulus" DISPLAYNAME="Youngs_modulus">
          <COLUMN UNIT="stress" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="200000 MPa"/>
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Poissons_ratio" DISPLAYNAME="Poissons_ratio">
          <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.29"/>
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Shear_modulus" DISPLAYNAME="Shear_modulus">
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Thermal_Expansion" DISPLAYNAME="Thermal_Expansion">
          <COLUMN UNIT="thermal expansion coefficient" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="1.13e-05 /K"/>
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Reference_Temperature" DISPLAYNAME="Reference_Temperature">
          <COLUMN UNIT="temperature" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="293.15 K"/>
         </ITEM>
         <ITEM KEY="Damping_coefficient" DISPLAYNAME="Damping_coefficient">
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Stress_Tension" DISPLAYNAME="Stress_Tension">
          <COLUMN UNIT="stress" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 MPa"/>
         </ITEM>
         <ITEM KEY="Stress_Compression" DISPLAYNAME="Stress_Compression">
          <COLUMN UNIT="stress" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 MPa"/>
         </ITEM>
         <ITEM KEY="Stress_Shear" DISPLAYNAME="Stress_Shear">
          <COLUMN UNIT="stress" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 MPa"/>
         </ITEM>
         <ITEM KEY="Mat_Cord_Sys" DISPLAYNAME="Mat_Cord_Sys">
          <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0"/>
         </ITEM>
        </CATEGORY>
        <CATEGORY NAME="Plastic">
         <ITEM KEY="Yield_Stress" DISPLAYNAME="Yield stress-strain table">
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Work_Hardening_Slope" DISPLAYNAME="Work hardening slope"/>
         <ITEM KEY="Hardening_Rule" DISPLAYNAME="Hardening rule">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Isotropic Hardening" INDEX="0" LIST="Isotropic Hardening"/>
         </ITEM>
         <ITEM KEY="Initial_yield_point" DISPLAYNAME="Initial yield point"/>
         <ITEM KEY="Yield_Criterion" DISPLAYNAME="Yield Criterion">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="VMISES" INDEX="0" LIST="VMISES"/>
         </ITEM>
         <ITEM KEY="Hardening_Param" DISPLAYNAME="Hardening Parameter"/>
        </CATEGORY>
        <CATEGORY NAME="Visco Plastic">
         <ITEM KEY="Hardening_Form" DISPLAYNAME="Hardening Form">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
         </ITEM>
         <ITEM KEY="A_Creep" DISPLAYNAME="Pre-exponential factor (A)"/>
         <ITEM KEY="A_NortonCreep" DISPLAYNAME="Pre-exponential factor (A)"/>
         <ITEM KEY="A_DornCreep" DISPLAYNAME="Pre-exponential factor (A)"/>
         <ITEM KEY="Css_Creep" DISPLAYNAME="Steady state creep prefactor (Css)"/>
         <ITEM KEY="n_Creep" DISPLAYNAME="Steady state creep stress exponent (n)"/>
         <ITEM KEY="m_Creep" DISPLAYNAME="Strain-rate sensitivity (m)"/>
         <ITEM KEY="B_Creep" DISPLAYNAME="Creep constant (B)"/>
         <ITEM KEY="Stress_Multiplier" DISPLAYNAME="Stress multiplier (?)"/>
         <ITEM KEY="Threshold_Stress_ForPowerLaw" DISPLAYNAME="Steady state creep power law breakdown (?)"/>
         <ITEM KEY="Universal_gas_constant" DISPLAYNAME="Universal gas constant (R)"/>
         <ITEM KEY="Activation_energy" DISPLAYNAME="Activation energy (dH)"/>
         <ITEM KEY="Absolute_zero_temperature" DISPLAYNAME="Absolute zero temperature (theta Z)"/>
         <ITEM KEY="Creep_Temperature_Exponent" DISPLAYNAME="Creep_Temperature_Exponent"/>
         <ITEM KEY="Creep_Stress_Exponent" DISPLAYNAME="Creep_Stress_Exponent"/>
         <ITEM KEY="Creep_Strain_Exponent" DISPLAYNAME="Creep_Strain_Exponent"/>
         <ITEM KEY="Creep_Time_Exponent" DISPLAYNAME="Creep_Time_Exponent"/>
         <ITEM KEY="Transient_CreepStrain" DISPLAYNAME="Transient creep strain (?T)"/>
         <ITEM KEY="Transient_Creep_coeff" DISPLAYNAME="Darveaux transient creep co-efficient (B)"/>
         <ITEM KEY="Creep_test_data" DISPLAYNAME="Creep test data">
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Operational_Stress_value" DISPLAYNAME="Operational Von-Mises Stress"/>
         <ITEM KEY="A_Creep_lower_bound" DISPLAYNAME="Lower bound value of pre-exponential factor (ALB)"/>
         <ITEM KEY="A_Creep_upper_bound" DISPLAYNAME="Upper bound value of pre-exponential factor (AUB)"/>
         <ITEM KEY="Strain_rate_sensitivity_hardening" DISPLAYNAME="Strain-rate sensitivity of hardening (a)"/>
         <ITEM KEY="Coefficient_deformation_resistance" DISPLAYNAME="Coefficient of deformation resistance (s?)"/>
         <ITEM KEY="Hardening_Polynomial_1" DISPLAYNAME="Hardening polynomial co-efficient 1 (A0)"/>
         <ITEM KEY="Hardening_Polynomial_2" DISPLAYNAME="Hardening polynomial co-efficient 2 (A1)"/>
         <ITEM KEY="Hardening_Polynomial_3" DISPLAYNAME="Hardening polynomial co-efficient 3 (A2)"/>
         <ITEM KEY="Hardening_Polynomial_4" DISPLAYNAME="Hardening polynomial co-efficient 4 (A3)"/>
         <ITEM KEY="Hardening_Polynomial_5" DISPLAYNAME="Hardening polynomial co-efficient 5 (A4)"/>
         <ITEM KEY="Deformation_Resistance_Polynomial_1" DISPLAYNAME="Polynomial co-efficient 1 of deformation resistance (S1)"/>
         <ITEM KEY="Deformation_Resistance_Polynomial_2" DISPLAYNAME="Polynomial co-efficient 2 of deformation resistance (S2)"/>
         <ITEM KEY="Deformation_Resistance_Polynomial_3" DISPLAYNAME="Polynomial co-efficient 3 of deformation resistance (S3)"/>
        </CATEGORY>
       </CATEGORY>
       <CATEGORY NAME="Thermal Properties">
        <ITEM KEY="Thermal_conductivity" DISPLAYNAME="Thermal_conductivity">
         <COLUMN UNIT="thermal conductivity" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.04981 W/(mm*K)"/>
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Heat_capacity" DISPLAYNAME="Heat_capacity">
         <COLUMN UNIT="specific heat" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="500 J/(kg*K)"/>
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Latent_Heat_Effect" DISPLAYNAME="Latent Heat Effect">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
        </ITEM>
        <ITEM KEY="Latent_Heat" DISPLAYNAME="Latent Heat"/>
        <ITEM KEY="Latent_Heat_Temperature" DISPLAYNAME="Latent Heat Temperature"/>
        <ITEM KEY="Latent_Heat_Temp_Interval" DISPLAYNAME="Latent Heat Temperature Interval"/>
        <ITEM KEY="Liquidus_Temperature" DISPLAYNAME="Liquidus Temperature"/>
        <ITEM KEY="Solidus_Temperature" DISPLAYNAME="Solidus Temperature"/>
        <ITEM KEY="Free_Convection" DISPLAYNAME="Free_Convection">
         <COLUMN UNIT="heat transfer coefficient" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 W/(mm2*K)"/>
        </ITEM>
        <ITEM KEY="Dynamic_Viscosity" DISPLAYNAME="Dynamic_Viscosity">
         <COLUMN UNIT="dynamic viscosity" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 N*s/mm2"/>
        </ITEM>
        <ITEM KEY="Transient_temperature_evolution" DISPLAYNAME="Transient temperature evolution">
         <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" CHECK="false"/>
        </ITEM>
        <CATEGORY NAME="Radiation">
         <ITEM KEY="Radiation_Effect" DISPLAYNAME="Radiation Effect">
          <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" CHECK="false"/>
         </ITEM>
         <ITEM KEY="Absorption_Coefficient" DISPLAYNAME="Absorption Coefficient"/>
         <ITEM KEY="Scattering_Coefficient" DISPLAYNAME="Scattering Coefficient"/>
         <ITEM KEY="Phase_Coefficient" DISPLAYNAME="Phase Coefficient"/>
         <ITEM KEY="Refractive_Index" DISPLAYNAME="Refractive Index"/>
        </CATEGORY>
        <ITEM KEY="Heat_Generation" DISPLAYNAME="Heat_Generation">
         <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="1.00"/>
        </ITEM>
        <ITEM KEY="Reference_Enthalpy" DISPLAYNAME="Reference_Enthalpy">
         <COLUMN UNIT="enthalpy" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mlJ"/>
        </ITEM>
        <ITEM KEY="TCH" DISPLAYNAME="TCH">
         <COLUMN UNIT="temperature" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 K"/>
        </ITEM>
        <ITEM KEY="TDELTA" DISPLAYNAME="TDELTA">
         <COLUMN UNIT="temperature" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 K"/>
        </ITEM>
        <ITEM KEY="QLAT" DISPLAYNAME="QLAT">
         <COLUMN UNIT="specific energy" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 J/kg"/>
        </ITEM>
       </CATEGORY>
       <CATEGORY NAME="Electrical Properties">
        <ITEM KEY="Electrical_Resistivity_Type" DISPLAYNAME="Electrical resistivity type">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
        </ITEM>
        <ITEM KEY="Electrical resistance at reference temperature" DISPLAYNAME="Electrical resistivity">
         <COLUMN UNIT="electrical resistivity" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.00014 Ohm*mm"/>
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Electrical_Conductivity" DISPLAYNAME="Electrical conductivity">
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Reference_Temperature_Resistivity" DISPLAYNAME="Reference temperature"/>
        <ITEM KEY="Temperature coefficient of resistance" DISPLAYNAME="Temperature coefficient of resistance">
         <COLUMN UNIT="thermal expansion coefficient" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 /K"/>
        </ITEM>
        <ITEM KEY="Thermal properties_electric" DISPLAYNAME="Thermal properties">
         <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" CHECK="false"/>
        </ITEM>
        <ITEM KEY="Temperature constant for electrical properties" DISPLAYNAME="Temperature constant"/>
        <ITEM KEY="Reference temperature for electrical properties" DISPLAYNAME="Reference temperature"/>
       </CATEGORY>
       <CATEGORY NAME="Magnetic Properties">
        <ITEM KEY="Magnet_Type" DISPLAYNAME="Type">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Soft Magnetic" INDEX="2" LIST="Soft Magnetic"/>
        </ITEM>
        <ITEM KEY="Permanent_Magnet_Type" DISPLAYNAME="BH Curve">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Linear" INDEX="0" LIST="Linear"/>
        </ITEM>
        <ITEM KEY="Soft_Magnetic_Type" DISPLAYNAME="BH Curve">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Non linear" INDEX="1" LIST="Non linear"/>
        </ITEM>
        <ITEM KEY="BH_Spline_Curve" DISPLAYNAME="BH - Spline">
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Remanent_Flux_Density" DISPLAYNAME="Remanent flux density"/>
        <ITEM KEY="Relative_Permeability" DISPLAYNAME="Relative permeability">
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Magnetic_Loss_Tangent" DISPLAYNAME="Magnetic loss tangent">
         <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
        </ITEM>
        <ITEM KEY="Coercive_FieldStrength" DISPLAYNAME="Coercive field strength"/>
        <ITEM KEY="Initial_Relative_Permeability" DISPLAYNAME="Initial relative permeability">
         <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="2022.683512965"/>
        </ITEM>
        <ITEM KEY="Maximum_Relative_Permeability" DISPLAYNAME="Maximum relative permeability"/>
        <ITEM KEY="Transversal_Relative_Permeability" DISPLAYNAME="Transversal relative permeability"/>
        <ITEM KEY="Third_Quadrant" DISPLAYNAME="Model in third quadrant">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Linear" INDEX="0" LIST="Linear"/>
        </ITEM>
        <ITEM KEY="Saturation_Magnetization" DISPLAYNAME="Saturation magnetization">
         <COLUMN UNIT="magnetic flux density" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="1.9 T"/>
        </ITEM>
        <ITEM KEY="Knee_Coefficient" DISPLAYNAME="Knee adjustment coefficient">
         <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.9336090087"/>
        </ITEM>
        <ITEM KEY="Iron_Loss_Computation" DISPLAYNAME="Iron loss computation">
         <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
        </ITEM>
        <ITEM KEY="K1_Modified_hysteresis_losses_coef" DISPLAYNAME="K1: Modified hysteresis losses coefficient"/>
        <ITEM KEY="K2_Modified_classical_losses_coef" DISPLAYNAME="K2: Modified classical losses coefficient"/>
        <ITEM KEY="K3_Modified_excess_losses_coef" DISPLAYNAME="K3: Modified excess losses coefficient"/>
        <ITEM KEY="a1_exponent_B_for_modified_hysteresis_losses" DISPLAYNAME="a1: Exponent of B for modified hysteresis losses"/>
        <ITEM KEY="a2_exponent_B_for_modified_classical_losses" DISPLAYNAME="a2: Exponent of B for modified classes losses"/>
        <ITEM KEY="a3_exponent_B_for_modified_excess_losses" DISPLAYNAME="a3: Exponent of B for excess classes losses"/>
        <ITEM KEY="Thermal properties_magnetic" DISPLAYNAME="Thermal properties">
         <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" CHECK="false"/>
        </ITEM>
        <ITEM KEY="Temperature constant for magnetic properties" DISPLAYNAME="Temperature constant"/>
        <ITEM KEY="Reference temperature for magnetic properties" DISPLAYNAME="Reference temperature"/>
        <ITEM KEY="Temperature_constant_soft_magnetic_nonlinear" DISPLAYNAME="Temperature constant"/>
        <ITEM KEY="Reference_temperature_soft_magnetic_nonlinear" DISPLAYNAME="Curie temperature"/>
       </CATEGORY>
       <CATEGORY NAME="Fatigue Properties">
        <CATEGORY NAME="Static parameters">
         <ITEM KEY="Yield_Strength" DISPLAYNAME="Yield_Strength"/>
         <ITEM KEY="Ultimate_Tensile_Strength" DISPLAYNAME="Ultimate_Tensile_Strength"/>
        </CATEGORY>
        <CATEGORY NAME="Stress Life parameters">
         <ITEM KEY="Fatigue_strength_coefficient_stress" DISPLAYNAME="Fatigue_strength_coefficient"/>
         <ITEM KEY="First_Fatigue_strength_Exponent" DISPLAYNAME="First_Fatigue_strength_Exponent"/>
         <ITEM KEY="Endurance_Cycle_Limit_or_Transition_Point" DISPLAYNAME="Endurance_Cycle_Limit_or_Transition_Point"/>
         <ITEM KEY="Second_Fatigue_strength_Exponent" DISPLAYNAME="Second_Fatigue_strength_Exponent"/>
         <ITEM KEY="Fatigue_Limit" DISPLAYNAME="Fatigue_Limit"/>
         <ITEM KEY="Standard_Error_of_Log" DISPLAYNAME="Standard_Error_of_Log"/>
         <ITEM KEY="Findley_Constant" DISPLAYNAME="Findley_Constant"/>
         <ITEM KEY="Region_Layer_stress" DISPLAYNAME="Region_Layer">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Worst" INDEX="0" LIST="Worst"/>
         </ITEM>
         <ITEM KEY="Material_Surface_Finish_Stress" DISPLAYNAME="Material_Surface_Finish">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
         </ITEM>
         <ITEM KEY="Material_Surface_Treatment_Stress" DISPLAYNAME="Material_Surface_Treatment">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
         </ITEM>
         <ITEM KEY="Fatigue_Strength_Reduction_Factor_Stress" DISPLAYNAME="Fatigue_Strength_Reduction_Factor"/>
         <ITEM KEY="Interpretation_Stress" DISPLAYNAME="Interpretation">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Range" INDEX="0" LIST="Range"/>
         </ITEM>
        </CATEGORY>
        <CATEGORY NAME="Strain Life parameters">
         <ITEM KEY="Fatigue_strength_coefficient_strain" DISPLAYNAME="Fatigue_strength_coefficient"/>
         <ITEM KEY="Fatigue_strength_exponent" DISPLAYNAME="Fatigue_strength_exponent"/>
         <ITEM KEY="Fatigue_ductility_exponent" DISPLAYNAME="Fatigue_ductility_exponent"/>
         <ITEM KEY="Fatigue_ductility_coefficient" DISPLAYNAME="Fatigue_ductility_coefficient"/>
         <ITEM KEY="Cyclic_strain_hardening_exponent" DISPLAYNAME="Cyclic_strain_hardening_exponent"/>
         <ITEM KEY="Cyclic_strength_coefficient" DISPLAYNAME="Cyclic_strength_coefficient"/>
         <ITEM KEY="Reversal_Limit_Of_Endurance" DISPLAYNAME="Reversal_Limit_Of_Endurance"/>
         <ITEM KEY="Standard_Error_of_Log_Elastic" DISPLAYNAME="Standard_Error_of_Log_Elastic"/>
         <ITEM KEY="Standard_Error_of_Log_Plastic" DISPLAYNAME="Standard_Error_of_Log_Plastic"/>
         <ITEM KEY="Shear_Fatigue_Strength_coefficient" DISPLAYNAME="Shear_Fatigue_Strength_coefficient"/>
         <ITEM KEY="Shear_Fatigue_Ductility_coefficient" DISPLAYNAME="Shear_Fatigue_Ductility_coefficient"/>
         <ITEM KEY="Shear_Fatigue_Strength_exponent" DISPLAYNAME="Shear_Fatigue_Strength_exponent"/>
         <ITEM KEY="Shear_Fatigue_Ductility_exponent" DISPLAYNAME="Shear_Fatigue_Ductility_exponent"/>
         <ITEM KEY="Strength_coefficient_factor" DISPLAYNAME="Strength_coefficient_factor"/>
         <ITEM KEY="Exponent_coefficient_factor" DISPLAYNAME="Exponent_coefficient_factor"/>
         <ITEM KEY="Maximum_Strain_value" DISPLAYNAME="Maximum_Strain_value"/>
         <ITEM KEY="Fatemi_Socie_Constant" DISPLAYNAME="Fatemi_Socie_Constant"/>
         <ITEM KEY="Brown_Miller_Constant" DISPLAYNAME="Brown_Miller_Constant"/>
         <ITEM KEY="Region_Layer_strain" DISPLAYNAME="Region_Layer">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Worst" INDEX="0" LIST="Worst"/>
         </ITEM>
         <ITEM KEY="Material_Surface_Finish_Strain" DISPLAYNAME="Material_Surface_Finish">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
         </ITEM>
         <ITEM KEY="Material_Surface_Treatment_Strain" DISPLAYNAME="Material_Surface_Treatment">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="None" INDEX="0" LIST="None"/>
         </ITEM>
         <ITEM KEY="Fatigue_Strength_Reduction_Factor_Strain" DISPLAYNAME="Fatigue_Strength_Reduction_Factor"/>
         <ITEM KEY="Interpretation_Strain" DISPLAYNAME="Interpretation">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Range" INDEX="0" LIST="Range"/>
         </ITEM>
        </CATEGORY>
        <CATEGORY NAME="Factor of Safety">
         <ITEM KEY="Torsion_fatigue_limit" DISPLAYNAME="Torsion_fatigue_limit">
          <COLUMN TYPE="FIELD_TABLE" DATATYPE="FIELD_TABLE" VALUE="none"/>
         </ITEM>
         <ITEM KEY="Hydrostatic_stress_sensitivity" DISPLAYNAME="Hydrostatic_stress_sensitivity"/>
         <ITEM KEY="Safe_zone_angle" DISPLAYNAME="Safe_zone_angle"/>
         <ITEM KEY="Shear_Threshold_Safezone" DISPLAYNAME="Shear_Threshold_Safezone"/>
         <ITEM KEY="Region_Layer" DISPLAYNAME="Region_Layer">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Worst" INDEX="0" LIST="Worst"/>
         </ITEM>
        </CATEGORY>
        <CATEGORY NAME="Difference in CTE solder parameters">
         <ITEM KEY="Creep_energy_density" DISPLAYNAME="Plastic work density"/>
        </CATEGORY>
        <CATEGORY NAME="Syed creep energy density solder parameters">
         <ITEM KEY="Creep_energy_density_Syedw" DISPLAYNAME="Creep energy density"/>
         <ITEM KEY="Creep_energy_density_exponent_Syedw" DISPLAYNAME="Creep energy density exponent"/>
        </CATEGORY>
        <CATEGORY NAME="Syed creep strain solder parameters">
         <ITEM KEY="Inverse_of_creep_ductility_Syedeps" DISPLAYNAME="Inverse of creep ductility"/>
         <ITEM KEY="Creep_strain_exponent_Syedeps" DISPLAYNAME="Creep strain exponent"/>
        </CATEGORY>
       </CATEGORY>
       <CATEGORY NAME="Failure Model">
        <CATEGORY NAME="Ductile failure">
         <ITEM KEY="Enable failure parameters" DISPLAYNAME="Johnson parameters">
          <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" CHECK="false"/>
         </ITEM>
         <ITEM KEY="D1" DISPLAYNAME="D1"/>
         <ITEM KEY="D2" DISPLAYNAME="D2"/>
         <ITEM KEY="D3" DISPLAYNAME="D3"/>
         <ITEM KEY="D4" DISPLAYNAME="D4"/>
         <ITEM KEY="D5" DISPLAYNAME="D5"/>
         <ITEM KEY="Failure reference strain rate" DISPLAYNAME="Failure reference strain rate"/>
         <ITEM KEY="Shell failure flag" DISPLAYNAME="Shell failure flag">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Default" INDEX="0" LIST="Default"/>
         </ITEM>
         <ITEM KEY="Solid failure flag" DISPLAYNAME="Solid failure flag">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Default" INDEX="0" LIST="Default"/>
         </ITEM>
         <ITEM KEY="Crack advancement criteria" DISPLAYNAME="Crack advancement criteria"/>
         <ITEM KEY="XFEM formulation flag" DISPLAYNAME="XFEM formulation flag">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Default" INDEX="0" LIST="Default"/>
         </ITEM>
        </CATEGORY>
        <CATEGORY NAME="Biquad failure">
         <ITEM KEY="Enable biquad failure parameters" DISPLAYNAME="BIQUAD parameters">
          <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" CHECK="false"/>
         </ITEM>
         <ITEM KEY="FB_UniaxialCompression" DISPLAYNAME="Uniaxial compression"/>
         <ITEM KEY="FB_Shear" DISPLAYNAME="Shear"/>
         <ITEM KEY="FB_UniaxialTension" DISPLAYNAME="Uniaxial tension"/>
         <ITEM KEY="FB_StrainTension" DISPLAYNAME="Strain tension"/>
         <ITEM KEY="FB_BiaxialTension" DISPLAYNAME="Biaxial tension"/>
         <ITEM KEY="FB_FailureThickness" DISPLAYNAME="Failure thickness"/>
         <ITEM KEY="FB_MaterialFlag" DISPLAYNAME="Material selector flag">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Default" INDEX="0" LIST="Default"/>
         </ITEM>
         <ITEM KEY="FB_BehaviourFlag" DISPLAYNAME="Behaviour flag">
          <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Two quadratic functions" INDEX="0" LIST="Two quadratic functions"/>
         </ITEM>
         <ITEM KEY="FB_InstabilityStart" DISPLAYNAME="Instability start"/>
         <ITEM KEY="Critical_Damage" DISPLAYNAME="Critical damage (%)"/>
        </CATEGORY>
       </CATEGORY>
       <CATEGORY NAME="Advanced Settings">
        <ITEM KEY="Surfacetension_constant" DISPLAYNAME="Surface Tension Constant"/>
       </CATEGORY>
      </TableData>
     </Material>''';
    simlab.execute(CreateMaterial);
    
    AnalysisProperty=''' <Property UUID="b05457c8-4e30-49ee-bddb-a2a20f04a3df">
      <tag Value="-1"/>
      <Name Value="Property1"/>
      <ID Value="1"/>
      <Dimension Value="Bar"/>
      <Type Value="Beam"/>
      <Behavior Value="Default"/>
      <Material Index="0" Value="Steel"/>
      <SupportEntities>
       <Entities>
        <Model>'''+ModelName+'''</Model>
        <Body>"'''+str(BarBodyName)+'''",</Body>
       </Entities>
      </SupportEntities>
      <CoordSystem Index="-1" Value=""/>
      <TableData>
       <ITEM KEY="Sys_Coord_Id" DISPLAYNAME="Sys Coord Id">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0"/>
       </ITEM>
       <ITEM KEY="Area" DISPLAYNAME="Area">
        <COLUMN UNIT="area" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="78.5398 mm2"/>
       </ITEM>
       <ITEM KEY="I1" DISPLAYNAME="I1">
        <COLUMN UNIT="inertia" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="490.874 mm4"/>
       </ITEM>
       <ITEM KEY="I2" DISPLAYNAME="I2">
        <COLUMN UNIT="inertia" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="490.874 mm4"/>
       </ITEM>
       <ITEM KEY="Torsional" DISPLAYNAME="Torsional">
        <COLUMN UNIT="inertia" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="981.748 mm4"/>
       </ITEM>
       <ITEM KEY="NSM" DISPLAYNAME="NSM">
        <COLUMN UNIT="lineic mass" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 kg/mm"/>
       </ITEM>
       <ITEM KEY="C1" DISPLAYNAME="C1">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="C2" DISPLAYNAME="C2">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="D1" DISPLAYNAME="D1">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="D2" DISPLAYNAME="D2">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="E1" DISPLAYNAME="E1">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="E2" DISPLAYNAME="E2">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="F1" DISPLAYNAME="F1">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="F2" DISPLAYNAME="F2">
        <COLUMN UNIT="length" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm"/>
       </ITEM>
       <ITEM KEY="K1" DISPLAYNAME="K1">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.9"/>
       </ITEM>
       <ITEM KEY="K2" DISPLAYNAME="K2">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.9"/>
       </ITEM>
       <ITEM KEY="I12" DISPLAYNAME="I12">
        <COLUMN UNIT="inertia" TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0 mm4"/>
       </ITEM>
       <ITEM KEY="PA" DISPLAYNAME="PA">
        <COLUMN TYPE="EDITBOX" DATATYPE="INT" VALUE="0"/>
       </ITEM>
       <ITEM KEY="PB" DISPLAYNAME="PB">
        <COLUMN TYPE="EDITBOX" DATATYPE="INT" VALUE="0"/>
       </ITEM>
       <ITEM KEY="SectionType" DISPLAYNAME="Section Type">
        <COLUMN TYPE="EDITBOX" DATATYPE="STRING" VALUE="O1Section"/>
       </ITEM>
       <ITEM KEY="SectionParam" DISPLAYNAME="Section Param">
        <COLUMN TYPE="EDITBOX" DATATYPE="STRING" VALUE="'''+str(BeamSecRad)+'''"/>
       </ITEM>
       <ITEM KEY="Ansys_Section_Offset" DISPLAYNAME="Ansys Section Offset">
        <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Centroid" INDEX="0" LIST="Centroid"/>
       </ITEM>
       <ITEM KEY="WriteMaterial" DISPLAYNAME="Write Material">
        <COLUMN TYPE="CHECKBOX" DATATYPE="BOOL" VALUE="" CHECK="true"/>
       </ITEM>
       <ITEM KEY="Abaqus_Element_Type" DISPLAYNAME="Abaqus Element Type">
        <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Default" INDEX="0" LIST="Default"/>
       </ITEM>
       <ITEM KEY="Nastran_Beam_Type" DISPLAYNAME="Nastran Beam Type">
        <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="PBEAML" INDEX="1" LIST="PBEAML"/>
       </ITEM>
       <ITEM KEY="Ansys_Element_Type" DISPLAYNAME="Ansys Element Type">
        <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="BEAM188_Linear" INDEX="0" LIST="BEAM188_Linear"/>
       </ITEM>
       <ITEM KEY="Small_Strain_Option" DISPLAYNAME="Small Strain Option">
        <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="0" INDEX="0" LIST="0"/>
       </ITEM>
       <ITEM KEY="Membrance_Damping" DISPLAYNAME="Membrance Damping">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.0"/>
       </ITEM>
       <ITEM KEY="Flexural_Damping" DISPLAYNAME="Flexural Damping">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.0"/>
       </ITEM>
       <ITEM KEY="Moment_of_Inertia_Bending_Y" DISPLAYNAME="Moment of Inertia Bending Y">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.0"/>
       </ITEM>
       <ITEM KEY="Moment_of_Inertia_Bending_Z" DISPLAYNAME="Moment of Inertia Bending Z">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.0"/>
       </ITEM>
       <ITEM KEY="Moment_of_Inertia_Torsion" DISPLAYNAME="Moment of Inertia Torsion">
        <COLUMN TYPE="EDITBOX" DATATYPE="DOUBLE" VALUE="0.0"/>
       </ITEM>
       <ITEM KEY="Rotation_DOF" DISPLAYNAME="Rotation DOF">
        <COLUMN TYPE="EDITBOX" DATATYPE="INT" VALUE="0.0"/>
       </ITEM>
       <ITEM KEY="Beam_Formulation" DISPLAYNAME="Beam Formulation">
        <COLUMN TYPE="COMBOBOX" DATATYPE="INDEX" VALUE="Include Shear" INDEX="0" LIST="Include Shear"/>
       </ITEM>
      </TableData>
      <Section Value="CIRCLE2">
       <R Value="'''+str(BeamSecRad)+'''"/>
      </Section>
     </Property>''';
    simlab.execute(AnalysisProperty);
    
else: 
    msgBox = simlab.pauseprocess('Please select two RBE bodies.',title="SimLab Error",Button1="OK",Button2="Close")

            
