#***************************************************************
#SimLab Version 2024.1 
#Created at Fri Jun 13 14:44:58 2025
#***************************************************************
from hwx import simlab

#Unit System
UnitSystem=''' <UnitSystem UUID="3aca8564-4d38-4b0b-887c-6a542d4001c6">
  <SetCurrentDisplaySystem Name="MMKS (mm kg N C s)"/>
 </UnitSystem>''';
simlab.execute(UnitSystem);

#Import the model
ImportSlb=''' <ImportSlb UUID="C806F6DF-56FA-4134-9AD1-1010BF292183" CheckBox="ON" gda="">
  <tag Value="1"/>
  <Name Value=""/>
  <FileName Value="./../Models/Turbulent_Flow_Elbow.slb"/>
  <ImportOrOpen Value="0"/>
  <Output/>
 </ImportSlb>''';
simlab.execute(ImportSlb);

#Choose the folder where you want to save the output files
SetSolutionWorkingFolder=''' <SetSolutionWorkingFolder UUID="fb4eafa8-d226-4a70-a21b-6791f0bd4599">
  <SolutionWorkingFolder Value="./../Output"/>
 </SetSolutionWorkingFolder>''';
simlab.execute(SetSolutionWorkingFolder);

#we setup the solution to get the h3d file (optional)
#Ohis for other solutions (it's not necessary)
ResultRequestOptions=''' <OutputRequestOption UUID="56b65ec2-6934-4a69-addf-732def4d4d2b" pixmap="solution">
  <tag Value="-1"/>
  <Name Value=""/>
  <SolverName Value="ACUSOLVE"/>
  <FileName Value=""/>
  <WriteMode Value=""/>
  <Renumber Value=""/>
  <RunSolver Value=""/>
  <RemoveOrphanNodes Value=""/>
  <Version Value="15"/>
  <SolverSetingType Value=""/>
  <SolutionName Value="Flow"/>
  <AnalysisType Value="STEADYSTATE" Index="0">
   <CATEGORY NAME="Output File Options">
    <ITEM DISPLAYNAME="Output File Format" KEY="Output File Format">
     <COLUMN DATATYPE="INT" TYPE="COMBOBOX" VALUE="h3d" LIST="h3d" INDEX="1"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Nodal Output">
    <ITEM DISPLAYNAME="Output frequency" KEY="Nodal output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="20"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Nodal output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Output initial condition">
     <COLUMN DATATYPE="BOOL" TYPE="CHECKBOX" VALUE="" CHECK="false"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Continuous output">
     <COLUMN DATATYPE="BOOL" TYPE="CHECKBOX" VALUE="" CHECK="false"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of nodal states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="1"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Derived Quantity Output">
    <ITEM DISPLAYNAME="Output frequency" KEY="Derived output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Derived output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of derived states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Running Average Output">
    <ITEM DISPLAYNAME="Output frequency" KEY="Running output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Running output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of nodal running states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Time Average Output">
    <ITEM DISPLAYNAME="" KEY="Order">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="2"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output frequency" KEY="Time output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Time output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Reset frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of time states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Error Estimator Output">
    <ITEM DISPLAYNAME="" KEY="Type">
     <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" VALUE="pde_residual" LIST="pde_residual" INDEX="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output frequency" KEY="Error output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Error output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of error states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Time average Output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Time average Output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="No. of time average saved states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Time average reset frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Restart Output">
    <ITEM DISPLAYNAME="Output frequency" KEY="Restart output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="1000"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Restart output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of restart states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Nodal Residual Output">
    <ITEM DISPLAYNAME="Output frequency" KEY="Residual output frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Residual output time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="No. of saved states" KEY="No. of residual states">
     <COLUMN DATATYPE="INT" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Time History Output">
    <ITEM DISPLAYNAME="Node set" KEY="Time history node set">
     <COLUMN DATATYPE="USER" TYPE="COMBOBOX" VALUE="None" LIST="None" INDEX="0"/>
    </ITEM>
    <ITEM DISPLAYNAME="Coordinates file" KEY="Coordinates file">
     <COLUMN DATATYPE="USER" TYPE="EDITBOXWITHBROWSER" VALUE=""/>
    </ITEM>
    <ITEM DISPLAYNAME="Output frequency" KEY="Time history frequency">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="1"/>
    </ITEM>
    <ITEM DISPLAYNAME="Output time interval" KEY="Time history time interval">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="0"/>
    </ITEM>
   </CATEGORY>
   <CATEGORY NAME="Heat Transfer Coefficient Output">
    <ITEM DISPLAYNAME="HTC method" KEY="HTC method">
     <COLUMN DATATYPE="INDEX" TYPE="COMBOBOX" VALUE="Turbulence Wall" LIST="Turbulence Wall" INDEX="2"/>
    </ITEM>
    <ITEM DISPLAYNAME="Film coefficient y-plus" KEY="HTC Film coefficient y-plus">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="100"/>
    </ITEM>
    <ITEM DISPLAYNAME="Reference temperature" KEY="User reference temperature">
     <COLUMN DATATYPE="DOUBLE" TYPE="EDITBOX" VALUE="300 K" UNIT="temperature"/>
    </ITEM>
    <ITEM DISPLAYNAME="" KEY="Limit reference temperature">
     <COLUMN DATATYPE="BOOL" TYPE="CHECKBOX" VALUE="" CHECK="true"/>
    </ITEM>
   </CATEGORY>
  </AnalysisType>
 </OutputRequestOption>''';
simlab.execute(ResultRequestOptions);

#Run and Solve the solution
ExportandSolve=''' <ExportStaticSolverInput UUID="f009bc99-991f-43b7-8c87-cc606ef9c443" pixmap="solution">
  <FileName Value=""/>
  <SolutionName Value="Flow"/>
  <LoadCase Value=""/>
  <Renumber Value="0"/>
  <RunSolver Value="1"/>
  <DataCheck Value="0"/>
  <RemoveOrphanNodes Value="1"/>
  <Version Value="15"/>
  <ExportOptionsVersion Value="1"/>
  <RemoteSolve Value="0"/>
  <CopyIncludeFiles Value="1"/>
 </ExportStaticSolverInput>''';
simlab.execute(ExportandSolve);

#This is pop-up window that the Solver shows before display the results
#You can ommit this for other solutions (it's not necessary)
PostDisplayMode=''' <PostDisplayMode UUID="95e3bea8-a2f3-4557-9482-d66ece623634">
  <SimLabDisplay Value="1"/>
  <PostMessage Value="0"/>
 </PostDisplayMode>''';
simlab.execute(PostDisplayMode);
